% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TAF-package.R
\docType{package}
\name{TAF-package}
\alias{TAF-package}
\alias{TAF}
\title{Transparent Assessment Framework for Reproducible Research}
\description{
General framework to organize data, methods, and results used in reproducible
scientific analyses. A TAF analysis consists of four scripts (\verb{data.R},
\verb{model.R}, \verb{output.R}, \verb{report.R}) that are run sequentially.
Each script starts by reading files from a previous step and ends with
writing out files for the next step.

Convenience functions are provided to version control the required data and
software, run analyses, clean residues from previous runs, manage files,
manipulate tables, and produce figures. With a focus on stability and
reproducible analyses, the TAF package comes with no dependencies. TAF forms
a base layer for the
\href{https://cran.r-project.org/package=icesTAF}{icesTAF} package and other
scientific applications.

The following diagram describes the general workflow of every TAF analysis:

\if{html}{\figure{diagram.png}{options: width="400" alt="diagram"}}
\if{latex}{\figure{diagram.pdf}{options: width=10cm}}

See \code{vignette("TAF")} for more detailed coverage on how to organize and
run TAF workflows.
}
\details{
\emph{Initial TAF steps:}
\tabular{ll}{
  \code{\link{draft.data}}     \tab draft DATA.bib file\cr
  \code{\link{draft.software}} \tab draft SOFTWARE.bib file\cr
  \code{\link{period}}         \tab paste period string for DATA.bib\cr
  \code{\link{taf.boot}}       \tab set up data files and software\cr
  \code{\link{taf.example}}    \tab copy example analysis from TAF package\cr
  \code{\link{taf.skeleton}}   \tab create empty TAF template
}
\emph{Running scripts:}
\tabular{ll}{
  \code{\link{clean}}      \tab clean TAF directories\cr
  \code{\link{clean.boot}} \tab clean boot directory\cr
  \code{\link{make}}       \tab run R script if needed\cr
  \code{\link{make.all}}   \tab run all TAF scripts as needed\cr
  \code{\link{make.taf}}   \tab run TAF script if needed\cr
  \code{\link{msg}}        \tab show message\cr
  \code{\link{source.all}} \tab run all TAF scripts\cr
  \code{\link{source.taf}} \tab run TAF script
}
\emph{File management:}
\tabular{ll}{
  \code{\link{convert.spaces}} \tab convert spaces\cr
  \code{\link{cp}}             \tab copy files\cr
  \code{\link{mkdir}}          \tab create directory\cr
  \code{\link{os.linux}}       \tab operating system\cr
  \code{\link{os.macos}}       \tab operating system\cr
  \code{\link{os.windows}}     \tab operating system\cr
  \code{\link{read.taf}}       \tab read CSV file\cr
  \code{\link{source.dir}}     \tab source all \code{*.R} files\cr
  \code{\link{taf.library}}    \tab load package from TAF library\cr
  \code{\link{taf.unzip}}      \tab unzip file\cr
  \code{\link{write.taf}}      \tab write CSV file
}
\emph{Tables:}
\tabular{ll}{
  \code{\link{ddim}}      \tab show data dimensions\cr
  \code{\link{div}}       \tab divide column values\cr
  \code{\link{flr2taf}}   \tab convert FLR to TAF\cr
  \code{\link{long2taf}}  \tab convert long format to TAF\cr
  \code{\link{long2xtab}} \tab convert long format to crosstab\cr
  \code{\link{plus}}      \tab rename plus group column\cr
  \code{\link{rnd}}       \tab round column values\cr
  \code{\link{sam2taf}}   \tab convert SAM to TAF\cr
  \code{\link{taf2html}}  \tab convert data frame to HTML\cr
  \code{\link{taf2long}}  \tab convert TAF to long format\cr
  \code{\link{taf2xtab}}  \tab convert TAF to crosstab\cr
  \code{\link{tt}}        \tab transpose TAF table\cr
  \code{\link{wide2long}} \tab convert wide to long format\cr
  \code{\link{xtab2long}} \tab convert crosstab to long format\cr
  \code{\link{xtab2taf}}  \tab convert crosstab to TAF
}
\emph{Plots:}
\tabular{ll}{
  \code{\link{lim}}        \tab compute axis limits\cr
  \code{\link{taf.colors}} \tab predefined colors\cr
  \code{\link{taf.png}}    \tab open PNG graphics device\cr
  \code{\link{zoom}}       \tab change lattice text size
}
\emph{Example tables:}
\tabular{ll}{
  \code{\link{catage.long}} \tab long format\cr
  \code{\link{catage.taf}}  \tab TAF format\cr
  \code{\link{catage.wide}} \tab wide format\cr
  \code{\link{catage.xtab}} \tab crosstab format\cr
  \code{\link{summary.taf}} \tab summary results
}
\emph{Example workflow:}
\tabular{ll}{
  \code{\link{linreg}} \tab simple linear regression
}
\emph{Administrative or auxiliary tools:}
\tabular{ll}{
  \code{\link{check.software}}  \tab check global package versions\cr
  \code{\link{clean.data}}      \tab clean boot data\cr
  \code{\link{clean.library}}   \tab clean TAF library\cr
  \code{\link{clean.software}}  \tab clean TAF software\cr
  \code{\link{deps}}            \tab workflow dependencies\cr
  \code{\link{detach.packages}} \tab detach all packages\cr
  \code{\link{dir.tree}}        \tab show directory structure\cr
  \code{\link{dos2unix}}        \tab convert line endings\cr
  \code{\link{download}}        \tab download file\cr
  \code{\link{download.github}} \tab download repository\cr
  \code{\link{draft.readme}}    \tab draft introductory readme\cr
  \code{\link{file.encoding}}   \tab examine file encoding\cr
  \code{\link{get.remote.sha}}  \tab look up SHA code\cr
  \code{\link{git.repo}}        \tab read Git repository name\cr
  \code{\link{install.deps}}    \tab install dependencies\cr
  \code{\link{is.r.package}}    \tab check if file is an R package\cr
  \code{\link{latin1.to.utf8}}  \tab convert file encoding\cr
  \code{\link{line.endings}}    \tab examine line endings\cr
  \code{\link{pdeps}}           \tab package dependencies\cr
  \code{\link{read.bib}}        \tab read metadata entries\cr
  \code{\link{rmdir}}           \tab remove empty directory\cr
  \code{\link{taf.boot.path}}   \tab construct path to boot folder\cr
  \code{\link{taf.data.path}}   \tab construct path to boot data files\cr
  \code{\link{taf.install}}     \tab install package in TAF library\cr
  \code{\link{taf.libPaths}}    \tab add TAF library to search path\cr
  \code{\link{taf.libraries}}   \tab load all packages from TAF library\cr
  \code{\link{taf.session}}     \tab show session information\cr
  \code{\link{taf.sources}}     \tab list metadata entries\cr
  \code{\link{unix2dos}}        \tab convert line endings\cr
  \code{\link{utf8.to.latin1}}  \tab convert file encoding
}
}
\examples{
\dontrun{
taf.example("linreg")
setwd("linreg")
taf.boot()
source.all()
}
}
\seealso{
See \code{vignette("TAF")} for an introduction to the TAF package.

The \href{https://github.com/ices-taf/doc/wiki}{TAF Wiki} provides additional
help resources.
}
\author{
Arni Magnusson, Colin Millar, and Iago Mosqueira.
}
