% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoCatCI.R
\name{twoCatCI}
\alias{twoCatCI}
\title{Confidence intervals and standard errors of multiple imputation for the cross-tabulation of two categorical variables.}
\usage{
twoCatCI(obs_data, imp_data_list, type, vars, sig = 4, alpha = 0.05)
}
\arguments{
\item{obs_data}{The original dataset to which the next will be compared, of the type "data.frame".}

\item{imp_data_list}{A list composed of \code{m} synthetic data sets.}

\item{type}{Specifies which type of datasets are in \code{imp_data_list}.  Options are "synthetic" and "imputed".}

\item{vars}{A vector of the two categorical variable being checked.  Should be of type "factor".}

\item{sig}{The number of significant digits in the output dataframes.  Defaults to 4.}

\item{alpha}{Test size, defaults to 0.05.}
}
\value{
This function returns a list of five data frames:

\item{Observed}{A cross-tabular proportion of observed values}

\item{Lower}{Lower limit of the confidence interval}

\item{Upper}{Upper limit of the confidence interval}

\item{SEs}{Standard Errors}

\item{CI_Indicator}{"YES"/"NO" indicating whether or not the observed value is within the confidence interval}
}
\description{
This function will calculate confidence intervals and standard errors from the proportional tabular responses of multiple imputed datasets for two categorical variables, and also give a YES/NO indicator for whether or not the observed value is within the confidence interval.
The confidence intervals and standard errors are calculated from formulas that are adapted for partially synthetic data sets.  See reference for more information.
}
\details{
This function was developed with the intention of making the job of researching partially synthetic data utility a bit easier by providing another way of measuring utility.
}
\examples{
#PPA is the observed data set.  PPAm5 is a list of 5 partially synthetic data sets derived from PPA.
#"sex" and "race" are categorical variables present in the synthesized data sets.
#3 significant digits are desired in the output dataframes.

twoCatCI(PPA, PPAm5, "synthetic", c("sex", "race"), sig=3)
}
\references{
\insertRef{adapt}{SynthTools}
}
\keyword{imputation}
\keyword{multiple}
\keyword{synds}
\keyword{synth}
\keyword{synthetic}
\keyword{utility}
