% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_shocks.R
\name{univariate_shocks}
\alias{univariate_shocks}
\title{Calculates 2d d-dimensional univariate shocks (up and down in each of the d dimensions) based on the given  ellipsoid. Univariate shocks are points on the surface of the ellipsoid that differ from the center of the  ellipsoid in only one dimension. Thus, for an ellipsoid centered at the origin, only one element of a d-dimensional shock will be non-zero.This function does not assume that the ellipsoid is centered at the origin.}
\usage{
univariate_shocks(hellip)
}
\arguments{
\item{hellip}{the basis for the shocks; it must have measurable width in every dimension}
}
\value{
A d x 2d array, [dx2d], with each column a shock; the first d columns are positive univariate shocks, and final d columns are matching negative univariate shocks
}
\description{
Calculates 2d d-dimensional univariate shocks (up and down in each of the d dimensions) based on the given  ellipsoid. Univariate shocks are points on the surface of the ellipsoid that differ from the center of the  ellipsoid in only one dimension. Thus, for an ellipsoid centered at the origin, only one element of a d-dimensional shock will be non-zero.This function does not assume that the ellipsoid is centered at the origin.
}
\examples{
hellip <- hyperellipsoid()
univariate_shocks(hellip)
}
