% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_results.R
\name{Read_Results}
\alias{Read_Results}
\alias{read_results}
\title{Reads swimming and diving results into a list of strings in preparation for
parsing with \code{swim_parse}}
\usage{
Read_Results(file, node = "pre")

read_results(file, node = "pre")
}
\arguments{
\item{file}{a .pdf or .html file (could be a url) where containing swimming
results.  Must be formatted in a "normal" fashion - see vignette}

\item{node}{a CSS node where html results are stored.  Required for html
results.  Default is "pre", which nearly always works.}
}
\value{
returns a list of strings containing the information from
  \code{file}.  Should then be parsed with \code{swim_parse}
}
\description{
Outputs list of strings to be processed by \code{swim_parse}
}
\examples{
\dontrun{read_results("http://www.nyhsswim.com/Results/Boys/2008/NYS/Single.htm", node = "pre")}

}
\seealso{
\code{read_results} is meant to be followed by
  \code{\link{swim_parse}}
}
