% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterSVM.R
\name{clusterSVM}
\alias{clusterSVM}
\title{Clustered Support Vector Machine}
\usage{
clusterSVM(
  x,
  y,
  centers = NULL,
  cluster.object = NULL,
  lambda = 1,
  sparse = TRUE,
  valid.x = NULL,
  valid.y = NULL,
  valid.metric = NULL,
  type = 1,
  cost = 1,
  epsilon = NULL,
  bias = TRUE,
  wi = NULL,
  verbose = 1,
  seed = NULL,
  cluster.method = "kmeans",
  cluster.fun = NULL,
  cluster.predict = NULL,
  ...
)
}
\arguments{
\item{x}{the nxp training data matrix. Could be a matrix or a sparse matrix object.}

\item{y}{a response vector for prediction tasks with one value for each of the n rows of \code{x}. 
For classification, the values correspond to class labels and can be a 1xn matrix, 
a simple vector or a factor.}

\item{centers}{an integer indicating the number of centers in clustering.}

\item{cluster.object}{an object generated from \code{cluster.fun}, and can be passed to \code{cluster.predict}}

\item{lambda}{the weight for the global l2-norm}

\item{sparse}{indicating whether the transformation results in a sparse matrix or not}

\item{valid.x}{the mxp validation data matrix.}

\item{valid.y}{if provided, it will be used to calculate the validation score with \code{valid.metric}}

\item{valid.metric}{the metric function for the validation result. By default it is the accuracy for classification.
Customized metric is acceptable.}

\item{type}{the type of the mission for \code{LiblineaR}.}

\item{cost}{cost of constraints violation (default: 1). 
Rules the trade-off between regularization and correct classification on data. 
It can be seen as the inverse of a regularization constant. 
See details in \code{LiblineaR}.}

\item{epsilon}{set tolerance of termination criterion for optimization. 
If NULL, the LIBLINEAR defaults are used, which are:}

\item{bias}{if bias is \code{TRUE} (default), instances of data becomes [data; 1].}

\item{wi}{a named vector of weights for the different classes, 
used for asymmetric class sizes. Not all factor levels have to be supplied (default weight: 1). 
All components have to be named according to the corresponding class label.}

\item{verbose}{if set to 0, no information is printed. 
If set to 1 (default), the running time and validation score (if applicable) will be printed.
If set to 2, the running time ,validation score (if applicable) and the \code{LiblineaR} information will be printed.}

\item{seed}{the random seed. Set it to \code{NULL} to randomize the model.}

\item{cluster.method}{The clusterign algorithm to use. Possible choices are 
\itemize{
    \item "kmeans" Algorithm from \code{stats::kmeans}
    \item "mlKmeans" Algorithm from \code{RcppMLPACK::mlKmeans}
    \item "kernkmeans" Algorithm from \code{kernlab::kkmeans}
}
If \code{cluster.fun} and \code{cluster.predict} are provided, \code{cluster.method} doesn't work anymore.}

\item{cluster.fun}{The function to train cluster labels for the data based on given number of centers. 
Customized function is acceptable, as long as the resulting list contains two fields named as \code{cluster} and \code{centers}.}

\item{cluster.predict}{The function to predict cluster labels for the data based on trained object. 
Customized function is acceptable, as long as the resulting list contains two fields named as \code{cluster} and \code{centers}.}

\item{...}{additional parameters passing to \code{cluster.fun}.}
}
\value{
\itemize{
   \item \code{svm} the svm object from \code{LiblineaR}
   \item \code{lambda} the parameter used.
   \item \code{sparse} whether the data is sparsely transformed
   \item \code{label} the clustering label for training data
   \item \code{centers} the clustering centers from teh training dataset
   \item \code{cluster.fun} the function used for clustering
   \item \code{cluster.object} the object either
   \item \code{cluster.predict} the function used for prediction on new data based on the object
   \item \code{valid.pred} the validation prediction
   \item \code{valid.score} the validation score
   \item \code{valid.metric} the validation metric
   \item \code{time} a list object recording the time consumption for each steps.
}
}
\description{
Implementation of Gu, Quanquan, and Jiawei Han. "Clustered support vector machines."
}
\examples{
data(svmguide1)
svmguide1.t = svmguide1[[2]]
svmguide1 = svmguide1[[1]]

csvm.obj = clusterSVM(x = svmguide1[,-1], y = svmguide1[,1], lambda = 1,
                      centers = 8, seed = 512, verbose = 0,
                      valid.x = svmguide1.t[,-1],valid.y = svmguide1.t[,1])
csvm.pred = csvm.obj$valid.pred

# Or predict from the data
pred = predict(csvm.obj, svmguide1.t[,-1])

}
