% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gater.R
\name{gater}
\alias{gater}
\title{Gater function for mixture SVMs}
\usage{
gater(x, y, S, hidden, learningrate = 0.01, threshold = 0.01,
  stepmax = 100, verbose = verbose, ...)
}
\arguments{
\item{x}{the nxp training data matrix. Could be a matrix or a sparse matrix object.}

\item{y}{a response vector for prediction tasks with one value for each of the n rows of \code{x}. 
For classification, the values correspond to class labels and can be a 1xn matrix, 
a simple vector or a factor. For regression, the values correspond to the values to predict, 
and can be a 1xn matrix or a simple vector.}

\item{S}{the prediction matrix from experts}

\item{hidden}{the number of neurons in the hidden layer}

\item{learningrate}{the learningrate for the back propagation}

\item{threshold}{neural network stops training once all gradient is below the threshold}

\item{stepmax}{the maximum iteration of the neural network training process}

\item{verbose}{a logical value indicating whether to print information of training.}

\item{...}{other parameters passing to \code{neuralnet}}
}
\description{
Gater function for mixture SVMs
}
