% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_tree_matrix.R
\name{survival_tree_matrix}
\alias{survival_tree_matrix}
\title{Build a Survival Tree (Data Supplied as Matrices)}
\usage{
survival_tree_matrix(
  time,
  event,
  matrix_numeric,
  matrix_factor,
  weights = rep(1, length(time)),
  significance = 0.05,
  min_weights = 50,
  missing = "omit",
  test_type = "univariate"
)
}
\arguments{
\item{time}{survival times, a numeric vector. 
\code{time[i]} is the survival time of the ith sample.}

\item{event}{survival events, a logical vector. 
\code{event[i]} is the survival event of the ith sample.}

\item{matrix_numeric}{numeric predictors, a numeric matrix. 
\code{matrix_numeric[i,j]} is the jth numeric predictor of the ith sample.}

\item{matrix_factor}{factor predictors, a character matrix. 
\code{matrix_factor[i,j]} is the jth predictor of the ith sample.}

\item{weights}{sample weights, a numeric vector. 
\code{weights[i]} is the weight of the ith sample.}

\item{significance}{significance threshold, a numeric value. 
Stop the splitting algorithm when no splits give a p-value smaller than \code{significance}.}

\item{min_weights}{minimum weight threshold, a numeric value. 
The weights in a node are greater than \code{min_weights}.}

\item{missing}{a character value that specifies the handling of missing data. 
If \code{missing=="omit"}, samples with missing values in the splitting variables will be discarded.
If \code{missing=="majority"}, samples with missing values in the splitting variables will be assigned to the majority node.
If \code{missing=="weighted"}, samples with missing values in the splitting variables will be weighted by the weights of branch nodes.}

\item{test_type}{a character value that specifies the type of statistical tests.
If \code{test_type=="univariate"}, then it performs a log-rank test without p-value adjustments.
If \code{test_type} is in \code{p.adjust.methods}, i.e., one of holm, hochberg, hommel, bonferroni, BH, BY, or fdr, 
then the p-values will be adjusted using the corresponding method.}
}
\value{
A list containing the information of the survival tree fit.
}
\description{
The function 
\code{survival_tree_matrix} build a survival tree given the survival outcomes and predictors of numeric and factor variables.
}
\details{
Build a Survival Tree (Data Supplied as Matrices)
}
