% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model_BinCont_copula.R
\name{fit_copula_model_BinCont}
\alias{fit_copula_model_BinCont}
\title{Fit copula model for binary true endpoint and continuous surrogate endpoint}
\usage{
fit_copula_model_BinCont(
  data,
  copula_family,
  marginal_surrogate,
  marginal_surrogate_estimator = NULL,
  twostep = FALSE,
  fitted_model = NULL,
  maxit = 500,
  method = "BFGS"
)
}
\arguments{
\item{data}{A data frame in the correct format (See details).}

\item{copula_family}{One of the following parametric copula families:
\code{"clayton"}, \code{"frank"}, \code{"gaussian"}, or \code{"gumbel"}.}

\item{marginal_surrogate}{Marginal distribution for the surrogate. For all
available options, see \code{?Surrogate::cdf_fun}.}

\item{marginal_surrogate_estimator}{Not yet implemented}

\item{twostep}{(boolean) if \code{TRUE}, the two step estimator implemented in
\code{\link[=twostep_BinCont]{twostep_BinCont()}} is used for estimation.}

\item{fitted_model}{Fitted model from which initial values are extracted. If
\code{NULL} (default), standard initial values are used. This option intended
for when a model is repeatedly fitted, e.g., in a bootstrap.}

\item{maxit}{Maximum number of iterations for the numeric optimization,
defaults to 500.}

\item{method}{Optimization algorithm for maximizing the objective function.
For all options, see \code{?maxLik::maxLik}. Defaults to \code{"BFGRS"}.}
}
\value{
WIP
}
\description{
The function \code{\link[=fit_copula_model_BinCont]{fit_copula_model_BinCont()}} fits the copula model for a
continuous surrogate endpoint and binary true endpoint. Because the bivariate
distributions of the surrogate-true endpoint pairs are functionally
independent across treatment groups, a bivariate distribution is fitted in
each treatment group separately.
}
