% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/px_utils.R
\docType{class}
\name{Image_Segmentation}
\alias{Image_Segmentation}
\title{Segmentation of images based on Superpixels, Affinity propagation and Kmeans clustering}
\usage{
# init <- Image_Segmentation$new()
}
\description{
Segmentation of images based on Superpixels, Affinity propagation and Kmeans clustering

Segmentation of images based on Superpixels, Affinity propagation and Kmeans clustering
}
\details{
\emph{sim_wL}, \emph{sim_wA}, \emph{sim_wB} are the weights of the three channels. They keep balance so as to be consistent with human perception.

The quantity \emph{colorradius} adjusts the number of clusters, and if its value is low, the number of targets would increase, which leads to more detailed segmentation results.

If the \emph{adjust_centroids_and_return_masks} parameter is set to FALSE then the output \emph{kmeans_image_data} will be an RGB image, otherwise it will be a black-and-white image.

\emph{colour_type} parameter: RGB (Red-Green-Blue), LAB (Lightness, A-colour-dimension, B-colour-dimension) or HSV (Hue, Saturation, Value) colour.

Higher resolution images give better results.

The \emph{affinity propagation} algorithm is used here with default parameter values.

By setting the \emph{sim_normalize} parameter to TRUE, the affinity propagation algorithm requires less iterations to complete. However, the \emph{colorradius} parameter does not have an
effect if the similarity matrix is normalized.


---------------kmeans initializers----------------------

\strong{optimal_init}   : this initializer adds rows of the data incrementally, while checking that they do not already exist in the centroid-matrix

\strong{quantile_init}  : initialization of centroids by using the cummulative distance between observations and by removing potential duplicates

\strong{kmeans++}       : kmeans++ initialization. Reference : http://theory.stanford.edu/~sergei/papers/kMeansPP-soda.pdf AND http://stackoverflow.com/questions/5466323/how-exactly-does-k-means-work

\strong{random}         : random selection of data rows as initial centroids
}
\section{Methods}{


\describe{
 \item{\code{Image_Segmentation$new()}}{}

 \item{\code{--------------}}{}

 \item{\code{spixel_segmentation()}}{}

 \item{\code{--------------}}{}

 \item{\code{spixel_masks_show()}}{}

 \item{\code{--------------}}{}

 \item{\code{spixel_clusters_show()}}{}

 \item{\code{--------------}}{}

 }
}

\examples{

library(SuperpixelImageSegmentation)

path = system.file("images", "BSR_bsds500_image.jpg", package = "SuperpixelImageSegmentation")

im = OpenImageR::readImage(path)

init = Image_Segmentation$new()

num_spix = 10           # for illustration purposes
# num_spix = 600        # recommended number of superpixels

spx = init$spixel_segmentation(input_image = im,
                               superpixel = num_spix,
                               AP_data = TRUE,
                               use_median = TRUE,
                               return_labels_2_dimensionsional = TRUE,
                               sim_color_radius = 10)


#...........................
# plot the superpixel labels
#...........................

plt = init$spixel_clusters_show(spix_labels = spx$spix_labels,
                                color_palette = grDevices::rainbow,
                                parameter_list_png = NULL)

# plt


#....................................................
# create a binary image for a specified cluster label
#....................................................

pix_values = spx$spix_labels

target_cluster = 3                               # determine clusters visually ('plt' variable)

pix_values[pix_values != target_cluster] = 0     # set all other values to 0 (background)
pix_values[pix_values == target_cluster] = 1     # set the target_cluster to 1 (binary image)

# OpenImageR::imageShow(pix_values)

}
\references{
https://pdfs.semanticscholar.org/6533/654973054b742e725fd433265700c07b48a2.pdf , "Image Segmentation using SLIC Superpixels and Affinity Propagation Clustering", Bao Zhou, 2013, International Journal of Science and Research (IJSR)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Image_Segmentation$new()}}
\item \href{#method-spixel_segmentation}{\code{Image_Segmentation$spixel_segmentation()}}
\item \href{#method-spixel_masks_show}{\code{Image_Segmentation$spixel_masks_show()}}
\item \href{#method-spixel_clusters_show}{\code{Image_Segmentation$spixel_clusters_show()}}
\item \href{#method-clone}{\code{Image_Segmentation$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Image_Segmentation$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-spixel_segmentation"></a>}}
\if{latex}{\out{\hypertarget{method-spixel_segmentation}{}}}
\subsection{Method \code{spixel_segmentation()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Image_Segmentation$spixel_segmentation(
  input_image,
  method = "slic",
  superpixel = 200,
  kmeans_method = "",
  AP_data = FALSE,
  use_median = TRUE,
  minib_kmeans_batch = 10,
  minib_kmeans_init_fraction = 0.5,
  kmeans_num_init = 3,
  kmeans_max_iters = 100,
  kmeans_initializer = "kmeans++",
  colour_type = "RGB",
  compactness_factor = 20,
  adjust_centroids_and_return_masks = FALSE,
  return_labels_2_dimensionsional = FALSE,
  sim_normalize = FALSE,
  sim_wL = 3,
  sim_wA = 10,
  sim_wB = 10,
  sim_color_radius = 20,
  verbose = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input_image}}{a 3-dimensional input image (the range of the pixel values should be preferably in the range 0 to 255)}

\item{\code{method}}{a character string specifying the superpixel method. It can be either "slic" or "slico"}

\item{\code{superpixel}}{a numeric value specifying the number of superpixels}

\item{\code{kmeans_method}}{a character string specifying the kmeans method. If not empty ("") then it can be either "kmeans" or "mini_batch_kmeans"}

\item{\code{AP_data}}{a boolean. If TRUE then the affinity propagation image data will be computed and returned}

\item{\code{use_median}}{a boolean. If TRUE then the median will be used rather than the mean value for the inner computations}

\item{\code{minib_kmeans_batch}}{the size of the mini batches}

\item{\code{minib_kmeans_init_fraction}}{percentage of data to use for the initialization centroids (applies if initializer is \emph{kmeans++} or \emph{optimal_init}). Should be a float number between 0.0 and 1.0.}

\item{\code{kmeans_num_init}}{number of times the algorithm will be run with different centroid seeds}

\item{\code{kmeans_max_iters}}{the maximum number of clustering iterations}

\item{\code{kmeans_initializer}}{the method of initialization. One of, \emph{optimal_init}, \emph{quantile_init}, \emph{kmeans++} and \emph{random}. See details for more information}

\item{\code{colour_type}}{a character string specifying the colour type. It can be one of "RGB", "LAB" or "HSV"}

\item{\code{compactness_factor}}{a numeric value specifying the compactness parameter in case that \emph{method} is "slic"}

\item{\code{adjust_centroids_and_return_masks}}{a boolean. If TRUE and the \emph{kmeans_method} parameter is NOT empty ("") then the centroids will be adjusted and image-masks will be returned. This will allow me to plot the masks using the \emph{spixel_masks_show} method.}

\item{\code{return_labels_2_dimensionsional}}{a boolean. If TRUE then a matrix of labels based on the output superpixels in combination with the Affinity Propagation clusters will be returned}

\item{\code{sim_normalize}}{a boolean. If TRUE then the constructed similarity matrix will be normalised to have unit p-norm (see the armadillo documentation for more details)}

\item{\code{sim_wL}}{a numeric value specifying the weight for the \emph{"L"} channel of the image (see the details section for more information)}

\item{\code{sim_wA}}{a numeric value specifying the weight for the \emph{"A"} channel of the image (see the details section for more information)}

\item{\code{sim_wB}}{a numeric value specifying the weight for the \emph{"B"} channel of the image (see the details section for more information)}

\item{\code{sim_color_radius}}{a numeric value specifying the \emph{colorradius} (see the details section for more information)}

\item{\code{verbose}}{a boolean. If TRUE then information will be printed in the console  (spixel_masks_show method)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-spixel_masks_show"></a>}}
\if{latex}{\out{\hypertarget{method-spixel_masks_show}{}}}
\subsection{Method \code{spixel_masks_show()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Image_Segmentation$spixel_masks_show(
  delay_display_seconds = 3,
  display_all = FALSE,
  margin_btw_plots = 0.15,
  verbose = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{delay_display_seconds}}{a numeric value specifying the seconds to delay the display of the next image (It displays the images consecutively). This parameter applies only if the \emph{display_all} is set to FALSE (spixel_masks_show method)}

\item{\code{display_all}}{a boolean. If TRUE then all images will be displayed in a grid  (spixel_masks_show method)}

\item{\code{margin_btw_plots}}{a float number specifying the margins between the plots if the \emph{display_all} parameter is set to TRUE  (spixel_masks_show method)}

\item{\code{verbose}}{a boolean. If TRUE then information will be printed in the console  (spixel_masks_show method)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-spixel_clusters_show"></a>}}
\if{latex}{\out{\hypertarget{method-spixel_clusters_show}{}}}
\subsection{Method \code{spixel_clusters_show()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Image_Segmentation$spixel_clusters_show(
  spix_labels,
  color_palette = grDevices::rainbow,
  parameter_list_png = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{spix_labels}}{a matrix. I can retrieve the "spix_labels" parameter by setting the "return_labels_2_dimensionsional" parameter to TRUE in the "spixel_segmentation" method  (spixel_clusters_show method)}

\item{\code{color_palette}}{one of the color palettes. Use  ?grDevices::topo.colors  to see the available color palettes}

\item{\code{parameter_list_png}}{either NULL or a list of parameters passed to the  ?grDevices::png  function, such as  list(filename = 'img.png', width = 100, height = 100, units = "px", pointsize = 12, bg = "white", type = "quartz")}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Image_Segmentation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
