% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Snorm-grad.R
\name{Snorm.grad}
\alias{Snorm.grad}
\title{Gradient of the loglikelihood of a multivariate normal with Toeplitz variance matrix.}
\usage{
Snorm.grad(X, mu, acf, dmu, dacf)
}
\arguments{
\item{X}{A length-\code{N} vector of multivariate normal observations.}

\item{mu}{A scalar or length-\code{N} vector of means.  If missing defaults to the vector of zeros.}

\item{acf}{A \code{Toeplitz} object or length-\code{N} vector containing the first column of the Toeplitz variance matrix.}

\item{dmu}{A length-\code{p} vector or \code{N x p} matrix of partial derivatives of \code{mu} along the columns.  If missing defaults to a matrix of zeros.}

\item{dacf}{An \code{N x p} matrix with the partial derivatives of \code{acf} along the columns.}
}
\value{
A length-\code{p} vector containing the gradient of the loglikelihood.
}
\description{
Superfast evaluation of loglikelihood gradient.
}
\examples{
# two parameter inference
acf.fun <- function(theta) theta[2]^2 * exp(-theta[1]*(1:N-1))
mu.fun <- function(theta) theta[1]

# partial derivatives
dacf.fun <- function(theta) {
  ea <- exp(-theta[1]*(1:N-1))
  cbind(-theta[1]*theta[2]^2 * ea, 2*theta[2] * ea)
}
dmu.fun <- function(theta) c(1, 0)

# generate data
N <- 300
theta <- rexp(2)
X <- rSnorm(n = 1, acf = acf.fun(theta)) + mu.fun(theta)

# likelihood gradient
Snorm.grad(X = X, mu = mu.fun(theta), dmu = dmu.fun(theta),
           acf = acf.fun(theta), dacf = dacf.fun(theta))
}
