% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/13-b-alt-unidir-aw-ovlp.r
\name{plot_overlap_alternative}
\alias{plot_overlap_alternative}
\title{a graphical display for showing relative proportions of pairwise subgroup overlap with two
unidirectional arrowed lines around two circle}
\usage{
plot_overlap_alternative(dat, covari.sel, para = c(0.5, 0.15, 1), mode,
  font.size = c(1.5, 1.5, 0.8), title = NULL)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of covariates}

\item{para}{a vector with three elements specifying the parameters of plot display; the first element is for specifying the length of the arrowhead;
the second is for specifying the width of the arrowheads; the third is for specifying the adjustment of the arrowhead
(there are three possible values, 0, 0.5 and 1)}

\item{mode}{a value specifying the type of display; either 1 or 2.}

\item{font.size}{a vector specifying the size of labels and text; the first element is for the title; the second is for the covariates labels.}

\item{title}{a string specifying the main title.}
}
\description{
this function produces a plot for displaying relative proportions of pairwise subgroup overlap, where the relative proportion
is defined by |intersect(A, B)|/|A|, for any sets A and B and A is the baseline set. The letters represent subgroups defined by
the categories of the selected covariates. Subgroup letters located around the two circles are considered as baselines; each has
unidirectional arrowed lines to the other. In addition, there are two modes of display - one is that arrowed lines have
different colours, reflecting the level of overlap proportions; the other is that lines have five thickness and types,
indicating five levels of overlap proportions.
}
\examples{
data(prca)
dat <- prca
## 1. Overlap alternative plot -------------------------------------------------
plot_overlap_alternative(dat = dat,
                         covari.sel = c(6,5,4,7),
                         mode = 1,
                         para = c(0, 0.6, 1),
                         font.size = c(1.2, 1.2, 0.8),
                         title = NULL)

}

