% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/13-d-matrix-overlap-plot-function.r
\name{plot_matrix_overlap}
\alias{plot_matrix_overlap}
\title{matrix plots for relative overlap proportions of pairwise subgroups}
\usage{
plot_matrix_overlap(dat, covari.sel, mode, font.size = c(2, 1, 0.8),
  title = NULL)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of covariates}

\item{mode}{a value specifying the type of display; either 1 or 2,}

\item{font.size}{a vector specifying the size of labels and text; the first element is for the title; the second is for the covariates labels.}

\item{title}{a string specifying the main title.}
}
\description{
this function produces a matrix plot for displaying relative proportions of pairwise subgroup overlap, where the relative proportion
is defined by |intersect(A, B)|/|A|, for any sets A and B and A is the baseline set. The letters over (and beside) the matrix
represent subgroups defined by the categories of the selected covariates. The subgroup letters on the rows are regarded as baseline
subgroups for calculating  relative overlap proportions. There are two modes of display - one with circles which are
placed in the cells, where the size and the colour reflect how large the proportion is; the other with colours filled in the
cells, where the colour indicate the level of overlap proportions.
}
\examples{
# Load the data to be used
data(prca)
dat <- prca

## 1. Matrix Overlap plot ---------------------------------------------------
plot_matrix_overlap(dat,
                    covari.sel = c(6,5,4,7),
                    mode = 1,
                    font.size = c(1.5, 1.25, 0.8),
                    title = NULL)

}

