% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_taphonomy.R
\name{apply_taphonomy}
\alias{apply_taphonomy}
\title{model taphonomic effects}
\usage{
apply_taphonomy(x, pres_potential, ctc)
}
\arguments{
\item{x}{events, e.g. times/ages of fossil occurrences or their stratigraphic position.}

\item{pres_potential}{function. Takes taphonomic conditions as input and returns the preservation potential (a number between 0 and 1)}

\item{ctc}{function, change in taphonomic conditions (ctc) with time or stratigraphic position.}
}
\value{
numeric vector, location/timing of events (e.g. fossil occurrences) after the taphonomic filter is applied
}
\description{
Models taphonomy by combining the change in taphonomic conditions with the preservation potential as a function of taphonomic conditions to determine how preservation potential changes. This is then used to systematically remove (thin) the event data using \code{thin}.
}
\examples{

# see
#vignette("advanced_functionality")
# for details on usage


}
\seealso{
\code{\link[=apply_niche]{apply_niche()}} for modeling niche preferences based on the same principle, \code{\link[=thin]{thin()}} for the underlying mathematical procedure.
}
