% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_param_txt.R
\name{set_param_txt}
\alias{set_param_txt}
\alias{set_usm_txt}
\alias{set_station_txt}
\alias{set_ini_txt}
\alias{set_general_txt}
\alias{set_tmp_txt}
\alias{set_plant_txt}
\alias{set_tec_txt}
\alias{set_soil_txt}
\title{Set (replace) STICS input file parameters}
\usage{
set_param_txt(
  workspace,
  param,
  value,
  append = FALSE,
  plant_id = 1,
  variety = NULL,
  value_id = NULL,
  stics_version = "latest",
  dirpath = lifecycle::deprecated(),
  add = lifecycle::deprecated(),
  plant = lifecycle::deprecated(),
  layer = lifecycle::deprecated()
)

set_usm_txt(
  file = "new_travail.usm",
  param,
  value,
  append = FALSE,
  filepath = lifecycle::deprecated(),
  add = lifecycle::deprecated()
)

set_station_txt(
  file = "station.txt",
  param,
  value,
  append = FALSE,
  filepath = lifecycle::deprecated(),
  add = lifecycle::deprecated()
)

set_ini_txt(
  file = "ficini.txt",
  param,
  value,
  append = FALSE,
  plant_id = 1,
  layer = NULL,
  stics_version = "latest",
  filepath = lifecycle::deprecated(),
  add = lifecycle::deprecated()
)

set_general_txt(
  file = "tempopar.sti",
  param,
  value,
  append = FALSE,
  filepath = lifecycle::deprecated(),
  add = lifecycle::deprecated()
)

set_tmp_txt(
  file = "tempoparv6.sti",
  param,
  value,
  append = FALSE,
  filepath = lifecycle::deprecated(),
  add = lifecycle::deprecated()
)

set_plant_txt(
  file = "ficplt1.txt",
  param,
  value,
  append = FALSE,
  variety = NULL,
  filepath = lifecycle::deprecated(),
  add = lifecycle::deprecated()
)

set_tec_txt(
  file = "fictec1.txt",
  param,
  value,
  append = FALSE,
  value_id = NULL,
  filepath = lifecycle::deprecated(),
  add = lifecycle::deprecated()
)

set_soil_txt(
  file = "param.sol",
  param,
  value,
  layer = NULL,
  stics_version = "latest",
  filepath = lifecycle::deprecated()
)
}
\arguments{
\item{workspace}{Path of the workspace containing the STICS (txt)
input files.}

\item{param}{Vector of parameter names.}

\item{value}{New parameter value}

\item{append}{Boolean. Append input to existing file}

\item{plant_id}{The plant identifier (main crop: 1 ; associated crop: 2).
Only used for plant, technical or initialisation parameters (default = 1).}

\item{variety}{The plant variety to set the parameter value,
either the variety name (\code{codevar} in the plant file) or
the index (\code{variete} in the technical file).}

\item{value_id}{The soil layers id or technical interventions id}

\item{stics_version}{An optional version name as listed in
get_stics_versions_compat() return}

\item{dirpath}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{dirpath} is no
longer supported, use \code{workspace} instead.}

\item{add}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{add} is no
longer supported, use \code{append} instead.}

\item{plant}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{plant} is no
longer supported, use \code{plant_id} instead.}

\item{layer}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{layer} is no
longer supported, use \code{value_id} instead.}

\item{file}{Path (including name) of the file to modify}

\item{filepath}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{filepath} is no
longer supported, use \code{file} instead.}
}
\value{
None
}
\description{
Replace or set an input parameter from a pre-existing
STICS input file.
}
\details{
The \code{plant} parameter can be either equal to \code{1},
\code{2} for the associated plant in the case of intercrop, or
\code{c(1,2)} for both Principal and associated plants.
\code{\link{get_var_info}} is a helper function that returns
all possible output variables.
If the \code{variety} is not given and if \code{param}
is a varietal parameter, the function will modify the value of
\code{param} for the simulated variety, as given
in the technical file.
}
\note{
\code{gen_varmod} is not used by \code{set_param_txt}.
To replace the output variables required from STICS,
please directly call \code{gen_varmod}.
}
\examples{
# Getting example data path
path <- get_examples_path(file_type = "txt")

# Change the value of durvieF for the current variety:
set_param_txt(workspace = path, param = "durvieF", value = 245)

# Change the value of durvieF for another variety:
set_param_txt(workspace = path, param = "durvieF",
              variety = "Nefer", value = 178)
# Change the value of soil parameter "cailloux" for all layers
# or a specific one
set_param_txt(workspace = path, param = "cailloux", value = 1)
set_param_txt(workspace = path, param = "cailloux", value_id = 2, value = 2)

# Change the value of parameter "amount" for all water supply interventions
# or a specific one
set_param_txt(workspace = path, param = "amount", value = 50)
set_param_txt(workspace = path, param = "amount", value_id = 2, value = 40)



}
