% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_estimation_fnxs.R
\name{estimate.d.RDB}
\alias{estimate.d.RDB}
\title{Estimate d using relative distance to boundary (RDB) methods}
\usage{
estimate.d.RDB(geno.matrix, fit.matrix, no.est = -100)
}
\arguments{
\item{geno.matrix}{Genotype matrix generated in
\code{\link{generate.geno.matrix}} or read in.}

\item{fit.matrix}{Fitness matrix generated in
\code{\link{sim.stick.data}} or read in.}

\item{no.est}{What to return when no estimate is obtained. Default is -100. Throws warning unless a number of NA is used.}
}
\value{
List: \cr
   [[1]] \code{d.hat} Is the best RDB estimate. It is the
  median of the positive individual RDB values. \cr
  [[2]] \code{d.hat.RDB.all} RDB estimate based on all individual estimates (not only postie values). \cr
  [[3]] \code{d.hat.RDB.ind} Vector of individual RDB values (see desalt).\cr
  [[4]] \code{d.hat.RDB.other} has alternative ways to combine the individual
  RDB estimates (i.e. median, mean, all values, postie values only).\cr
  \code{d.hat.median.pos} is preferred estimator (\code{d.hat} above) from
  the median of positive individual values. \cr \code{d.hat.median} is median
  of all values. \cr \code{d.hat.mean} is mean of all values.\cr
  \code{d.hat.mean.pos} is mean of positive values.
}
\description{
Estimate d using relative distance to boundary (RDB) methods
}
\details{
The method calculates RDB for each genotype and its complement. The
  \code{d.hat.RDB.all} indicate the genotype pair that produces the estimate.
}
\examples{
n.muts <- length(Khan.data[1,])-1
geno.matrix <- Khan.data[,seq(1, n.muts)]
fit.matrix <- as.matrix(Khan.data[,(n.muts+1)])
estimate.d.RDB(geno.matrix, fit.matrix,-100)
}

