% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_DesMat.R
\name{construct_trtMat}
\alias{construct_trtMat}
\title{Construct Treatment Matrix}
\usage{
construct_trtMat(Cl, trtDelay, dsntype, timepoints = NULL)
}
\arguments{
\item{Cl}{integer (vector), number of clusters per sequence group (in SWD),
or number in control and intervention (in parallel designs)}

\item{trtDelay}{numeric (possibly vector), value(s)
between 0 and 1 specifying the proportion of intervention effect
in the first (second ... ) intervention phase.}

\item{dsntype}{character, defines the type of design. Options are "SWD",
"parallel" and "parallel_baseline", defaults to "SWD".}

\item{timepoints}{numeric (scalar or vector), number of timepoints (periods).
If design is swd, timepoints defaults to length(Cl)+1.
Defaults to 1 for parallel designs.}
}
\value{
a matrix trtMat, where rows and columns correspond to cluster
and timepoints, respectively
}
\description{
Constructs a matrix of `#cluster` rows and `#timepoint` columns, indicating
treatment status in each cluster at each timepoint.
}
\examples{
construct_trtMat(Cl=c(1,2,1), trtDelay=c(.2,.8), dsntype="SWD")


}
