% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_CovMat.R
\name{construct_CovSubMat}
\alias{construct_CovSubMat}
\title{Construct a Block of the Covariance Matrix}
\usage{
construct_CovSubMat(
  N,
  timepoints,
  sigma,
  tau,
  eta = NULL,
  tauAR = NULL,
  etaAR = NULL,
  rho = NULL,
  gamma = 0,
  trtMat = NULL,
  psi = NULL,
  INDIV_LVL = FALSE
)
}
\arguments{
\item{N}{Number of individuals per cluster}

\item{timepoints}{numeric (scalar or vector), number of timepoints (periods).
If design is swd, timepoints defaults to length(Cl)+1.
Defaults to 1 for parallel designs.}

\item{sigma}{numeric (vector of length `timepoints`),
residual error}

\item{tau}{numeric (vector of length `timepoints`),
standard deviation of random intercepts}

\item{eta}{numeric (vector of length `timepoints`),
standard deviation of random slope}

\item{tauAR}{numeric (scalar), value between 0 and 1. Defaults to NULL.
If `tauAR` is not NULL, the random intercept `tau` is AR1-correlated.
*Currently not compatible with `rho`!=0 !*}

\item{etaAR}{numeric (scalar), value between 0 and 1. Defaults to NULL.
If `etaAR` is not NULL, the random slope `eta` is AR1-correlated.
*Currently not compatible with `rho`!=0 !*}

\item{rho}{numeric (scalar), correlation of `tau` and `eta`}

\item{gamma}{numeric (vector of length `timepoints`),
standard deviation of a random time effect.}

\item{trtMat}{a matrix of dimension *#Cluster* x *timepoints* as produced by
the function `construct_trtMat`, indicating the cluster-periods that receive
interventional treatment. Defaults to NULL. If trtMat is given, the arguments
`SumCl` and `timepoints` are ignored (!).}

\item{psi}{numeric (scalar), random subject specific intercept.
Leads to a closed cohort setting}

\item{INDIV_LVL}{logical, should the computation be conducted on an
individual level? This leads to longer run time and is
mainly for diagnostic purposes.}
}
\value{
a block of a covariance matrix with two levels of clustering,
corresponding to intra-cluster covariance over time for one cluster
}
\description{
Constructs the covariance matrix
for multiple measurements of the same cluster
if the same individuals are observed at all time periods.
This function is not designed to be used directly.
}
