% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report}
\alias{report}
\title{report from a StepReg object}
\usage{
report(x, report_name, format = c("html", "docx", "rtf", "pptx"))
}
\arguments{
\item{x}{StepReg object}

\item{report_name}{report name}

\item{format}{the format of report, choose one or more from 'html', 'docx', 'rtf', 'pptx'. default is 'html'}
}
\description{
report output all tables in StepReg object to a report with format of html, docx, pptx, rtf, and xlsx.
}
\examples{
\dontrun{
data(mtcars)
mtcars$yes <- mtcars$wt
formula <- mpg ~ . + 0
x <- stepwise(formula = formula,
              data = mtcars,
              type = "linear",
              strategy = "bidirection",
              metric = c("AIC", "BIC"))
report(x,report_name = "report", format = c("html","docx"))
}
}
