# Introduction
Exploratory data analysis (EDA) is the first step performed in a classical statistical data analysis or machine learning model development. 
The Statsomat/EDAPY app is a web-based application for automated EDA with Python and created with the Shiny technology in combination with the 
R `reticulate` package. 

The Statsomat/EDAPY app is hosted on [shinyapps.io](https://www.shinyapps.io/) and 
is one of several apps which can be accessed via the webpage of Statsomat (see https://statsomat.com), 
a nonprofit portal with the aim of developing, collecting and maintaining open-source apps for automated data analysis and
automated interpretation. 

You can also access the app directly  https://statsomat.shinyapps.io/edapy/. 

# Installation 
There is no need to install the Statsomat/EDAPY app since it runs in the browser. If you really want to run it locally, 
then download the repository and run the app from the project folder: 

```
shiny::runApp()
```

Before running the app locally, please consider to install required R and Python packages. Moreover, you need to update the `.Renviron` file for your local system - in the repo it is setup for [shinyapps.io](https://www.shinyapps.io/)

# Example Usage
 Choose a CSV file to upload and follow the *Instructions* described directly on the webpage of the app https://statsomat.shinyapps.io/edapy/. 


# Functionality
The user uploads the data as a CSV file. A PDF report is generated and finally downloaded. The PDF report contains 
the most important univariate EDA statistics and graphics. Moreover, the user can generate a file containing the Python code which can be used for learning or 
to reproduce results locally.


# Tests 
The app was tested and validated by a pool of datasets. Outputs were compared to outputs generated by the R packages for EDA `pastecs` and `psych`.  


# Community 
1) Contribute to the software:
You are welcome to improve and extend the functionality of the app. If you want to make a pull request, please check that you can run test cases locally without any errors or warnings. 
Please consider to test your changes also on [shinyapps.io](https://www.shinyapps.io/). 
While uploading, ignore the `Error in eval(x, envir = envir)`, it is a non-fatal error, 
also related to related to https://github.com/rstudio/packrat/issues/385 and https://github.com/rstudio/rsconnect/issues/429.  

2) Report issues or problems with the software:
Please open an issue in this repository to report any bugs. 

3) Seek support:
We try to answer all questions in reasonable time  but general support is limited. 

