% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/randomise.R
\name{randomise}
\alias{randomise}
\title{Order the rows of a data randomly}
\usage{
randomise(data, seed = NULL)
}
\arguments{
\item{data}{a matrix, data.frame or data.table}

\item{seed}{an integer value}
}
\value{
\code{data} of same class as input with randomly ordered observations
}
\description{
Takes in data and seed, and returns the data with randomly ordered observations
}
\details{
Some of the modeling algorithms pick top p percent of the observations for
 training the model, which could lead to skewed predictions. This function
 solves that problem by randomly ordering the observations so that the response
 variable has more or less the same distribution even if the algorithms don't pick
 training observations randomly.
}
\examples{
# A 'data.frame'
df <- data.frame(x = c(1, 2, 3, 4, 5), y = c('a', 'b', 'c', 'd', 'e'))

# Change the order of the observations randomly
dfRan <- randomise(data = df)
dfRan <- randomise(data = df, seed = 150)
}
\author{
Akash Jain
}
\seealso{
\code{\link{factorise}}, \code{\link{rmdupkey}}, \code{\link{rmdupobs}}
}

