% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotbootStMoMo.R
\name{plot.bootStMoMo}
\alias{plot.bootStMoMo}
\title{Plot bootstrapped parameters of a Stochastic Mortality Model}
\usage{
\method{plot}{bootStMoMo}(x, nCol = 2, parametricbx = TRUE, 
                          colour = rgb(0, 0, 0), 
                          probs = c(2.5, 10, 25, 50, 75, 90, 97.5), ...)
}
\arguments{
\item{x}{an object of class \code{"bootStMoMo"} with the bootstrapped 
parameters of a stochastic mortality model.}

\item{nCol}{number of columns to use in the plot.}

\item{parametricbx}{if \code{FALSE} parametric age-modulating terms, 
which don't need to be estimated, are not plotted.}

\item{colour}{colour to use in the fans.}

\item{probs}{probabilities related to percentiles to plot in the fan chart.
The  default \code{c(2.5,10,25,50,75,90,97.5)} plots the 50\%, 80\% and 
95\% confidence intervals of the parameters.}

\item{...}{other arguments.}
}
\description{
Plot fancharts of bootstrapped parameters of a Stochastic Mortality Model 
stored in an object of class \code{"bootStMoMo"}.
}
\examples{
#Long computing times
\dontrun{
CBDfit <- fit(cbd(), data = central2initial(EWMaleData),
              ages.fit = 55:89)
CBDResBoot <- bootstrap(CBDfit, nBoot = 500)
plot(CBDResBoot)
plot(CBDResBoot, parametricbx = FALSE, probs = seq(2.5, 97.5, 2.5))
}

}
\seealso{
\code{\link{plot.fitStMoMo}}
}
