# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Heuristic Product Within Distance (Spatially Balanced Sampling).
#'
#' The function \code{hpwd} provides a fast selection of spatially balanced samples: it is a heuristic and a fast implemention of the algorithm \code{\link{pwd}}.
#' It generates samples approximately with the same probabilities of the \code{\link{pwd}} but with a significantly smaller number of steps.
#' In fact, this algorithm randomly selects a sample of size \eqn{n} exactly with \eqn{n} steps, updating at each step the selection probability of not-selected units, depending on their distance from the units, that were already selected in the previous steps.
#' Note that the inclusion probabilities are all constant and equal to \eqn{nsamp/N}, where \eqn{nsamp} is sample size and \eqn{N} is population size.
#'
#' @param dis A distance matrix NxN that specifies how far are all the pairs of units in the population.
#' @param nsamp Sample size.
#' @param nrepl Number of samples drawn.
#' @return Return a matrix 2x\code{nrepl} with \code{nrepl} samples drawn. In particular, the element \eqn{a_{ij}}{a_ij} is the j-th unit of the population drawn in the i-th sample.
#' @references
#' \insertRef{BIMJ:BIMJ1785}{Spbsampling}
#'
#' \insertRef{fast_selection}{Spbsampling}
#' @examples
#' ##Example 1
#' ##Draw 50 samples of dimension 10 without constant probabilities
#' dis<-as.matrix(dist(cbind(lucas_abruzzo$x,lucas_abruzzo$y))) #distance matrix
#' drawn_samples<-hpwd(dis,10,50)
#' \donttest{
#' ##Example 2
#' ##Draw 100 samples of dimension 15 with constant probabilities equal to nsamp/N
#' #with N=population size
#' dis<-as.matrix(dist(cbind(lucas_abruzzo$x,lucas_abruzzo$y))) #distance matrix
#' vec<-rep(1,nrow(dis)) #vector of constraints
#' stand_dist<-stprod(dis,vec,1e-15,1000) #standardized matrix
#' drawn_samples<-hpwd(stand_dist,15,100)
#' }
#' @export
hpwd <- function(dis, nsamp, nrepl) {
    .Call('_Spbsampling_hpwd', PACKAGE = 'Spbsampling', dis, nsamp, nrepl)
}

#' Product Within Distance (Spatially Balanced Sampling).
#'
#' This is an implemention of a spatially balanced design, with a probability function proportional to the within sample distance, using the product of distance as an index of the within sample distance (Product Within Distance, \code{pwd} in short).
#' To have constant inclusion probabilities \eqn{\pi_{i}=nsamp/N}, where \eqn{nsamp} is sample size and \eqn{N} is population size, the distance matrix has to be standardized with function \code{\link{stprod}}.
#'
#' @param dis A distance matrix NxN that specifies how far are all the pairs of units in the population.
#' @param niter Number of iterations for the algorithm. More iterations are better but require more time. Usually 10 is very efficient.
#' @param nsamp Sample size.
#' @param nrepl Number of samples drawn.
#' @return Return a matrix 2x\code{nrepl} with \code{nrepl} samples drawn. In particular, the element \eqn{a_{ij}}{a_ij} is the j-th unit of the population drawn in the i-th sample.
#' @references
#' \insertRef{BIMJ:BIMJ1785}{Spbsampling}
#' @examples
#' #Example 1
#' #Draw 20 samples of dimension 15 without constant probabilities
#' dis<-as.matrix(dist(cbind(lucas_abruzzo$x,lucas_abruzzo$y))) #distance matrix
#' nsamp<-15  #sample size
#' nrepl<-20  #number of samples to draw
#' niter<-10  #number of iterations in the algorithm
#' drawn_samples<-pwd(dis,niter,nsamp,nrepl)  #drawn samples
#' \donttest{
#' #Example 2
#' #Draw 20 samples of dimension 15 with constant probabilities equal to nsamp/N
#' #with N=population size
#' dis<-as.matrix(dist(cbind(lucas_abruzzo$x,lucas_abruzzo$y))) #distance matrix
#' nsamp<-15  #sample size
#' nrepl<-20  #number of samples to draw
#' niter<-10  #number of iterations in the algorithm
#' vec<-rep(1,nrow(dis)) #vector of constraints
#' stand_dist<-stprod(dis,vec,1e-15,1000) #standardized matrix
#' drawn_samples<-pwd(stand_dist,niter,nsamp,nrepl)  #drawn samples
#' }
#' @export
pwd <- function(dis, niter, nsamp, nrepl) {
    .Call('_Spbsampling_pwd', PACKAGE = 'Spbsampling', dis, niter, nsamp, nrepl)
}

#' Sum Within Distance (Spatially Balanced Sampling).
#'
#' This is an implemention of a spatially balanced design, with a probability function proportional to the within sample distance, using the sum of distance as an index of the within sample distance (Sum Within Distance, \code{swd} in short).
#' To have a constant inclusion probabilities \eqn{\pi_{i}=nsamp/N}, where \eqn{nsamp} is sample size and \eqn{N} is population size, standardize the distance matrix with function \code{\link{stsum}}.
#'
#' @param dis A distance matrix NxN that specifies how far are all the pairs of units in the population.
#' @param niter Number of iterations for the algorithm.
#' @param nsamp Sample size.
#' @param nrepl Number of samples drawn.
#' @param bexp Parameter \eqn{\beta} for the algorithm. The higher \eqn{\beta} is, the more the sample is going to be spread.
#' @return Return a matrix 2 x \code{nrepl} with \code{nrepl} samples drawn. In particular, the element \eqn{a_{ij}}{a_ij} is the j-th unit of the population drawn in the i-th sample.
#' @references
#' \insertRef{BIMJ:BIMJ1785}{Spbsampling}
#' @examples
#' #Example 1
#' #Draw 20 samples of dimension 15 without constant probabilities
#' dis<-as.matrix(dist(cbind(income_emilia$x_coord,income_emilia$y_coord))) #distance matrix
#' nsamp<-15  #sample size
#' nrepl<-20  #number of samples to draw
#' niter<-10  #number of iterations in the algorithm
#' bexp<-10   #parameter \eqn{\beta}
#' drawn_samples<-swd(dis,niter,nsamp,nrepl,bexp)  #drawn samples
#' \donttest{
#' #Example 2
#' #Draw 20 samples of dimension 15 with constant probabilities equal to nsamp/N
#' #with N=population size
#' dis<-as.matrix(dist(cbind(income_emilia$x_coord,income_emilia$y_coord))) #distance matrix
#' nsamp<-15  #sample size
#' nrepl<-20  #numbers of samples to drawn
#' niter<-10  #numbers of iterations in the algorithm
#' bexp<-10  #parameter \eqn{\beta}
#' vec<-rep(1,nrow(dis)) #vector of constraints
#' stand_dist<-stsum(dis,vec,1e-15,1000) #standardized matrix
#' drawn_samples<-swd(stand_dist,niter,nsamp,nrepl,bexp)  #drawn samples
#' }
#' @export
swd <- function(dis, niter, nsamp, nrepl, bexp) {
    .Call('_Spbsampling_swd', PACKAGE = 'Spbsampling', dis, niter, nsamp, nrepl, bexp)
}

