% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routines.R
\name{count_triples}
\alias{count_triples}
\title{Count number of triples of overlapping lists}
\usage{
count_triples(zdat)
}
\arguments{
\item{zdat}{Data matrix with \eqn{t+1} columns. The first \eqn{t} columns, each corresponding to a particular list,
are 0s and 1s defining the capture histories
observed. The last column is the count of cases with that particular capture history.
List names A, B, ... are constructed if not supplied. Where a capture history is not explicitly listed,
it is assumed that it has zero count.}
}
\value{
a count of subsets of size three of lists such that every pair of lists in the triple overlaps.
}
\description{
The routine counts the number of subsets of size three of lists such that every pair of
lists in the triple overlaps. If the number is zero, then the model with all two-list effects
is unidentifiable.
}
\examples{
data(Western)
data(Artificial_3)
count_triples(Western)
count_triples(Artificial_3)

}
