% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{rank}
\alias{rank}
\alias{rank}
\alias{rank,missing-method}
\alias{rank}
\alias{rank,ANY-method}
\title{rank}
\usage{
rank(x, ...)

\S4method{rank}{missing}()

\S4method{rank}{ANY}(x, ...)
}
\arguments{
\item{x}{a numeric, complex, character or logical vector.}

\item{...}{additional argument(s) passed to the method.}
}
\description{
Window function: returns the rank of rows within a window partition.
}
\details{
The difference between rank and dense_rank is that dense_rank leaves no gaps in ranking
sequence when there are ties. That is, if you were ranking a competition using dense_rank
and had three people tie for second place, you would say that all three were in second
place and that the next person came in third. Rank would give me sequential numbers, making
the person that came in third place (after the ties) would register as coming in fifth.

This is equivalent to the RANK function in SQL.
}
\note{
rank since 1.6.0
}
\examples{
\dontrun{
  df <- createDataFrame(mtcars)
  ws <- orderBy(windowPartitionBy("am"), "hp")
  out <- select(df, over(rank(), ws), df$hp, df$am)
}
}
\seealso{
Other window_funcs: \code{\link{cume_dist}},
  \code{\link{dense_rank}}, \code{\link{lag}},
  \code{\link{lead}}, \code{\link{ntile}},
  \code{\link{percent_rank}}, \code{\link{row_number}}
}
