% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subpop.R
\name{summary.subpop}
\alias{summary.subpop}
\title{Return the output of \code{\link{subpop}} function.}
\usage{
\method{summary}{subpop}(object, vars = NULL, ...)
}
\arguments{
\item{object}{Output of \code{\link{subpop}} command.}

\item{vars}{The variables that users want to see the summary
statistics. The default is \code{NULL} and the command
shows all variables. The summary statistcs include min
1st quartile, median, mean, 3rd quartile and the max.}

\item{...}{additional arguments affecting the summary produced.}
}
\description{
The \code{\link{subpop}} function stores the most and least affected groups.
This command allows users to see these two groups and their corresponding
characteristics. The command also allows users to check the summary
statistics of variables in interest, which can be useful for plotting the
projections plot via the \code{\link{plot.subpop}} method.
}
\examples{
data("mortgage")
### Regression Specification
fm <- deny ~ black + p_irat + hse_inc + ccred + mcred + pubrec +
   ltv_med + ltv_high + denpmi + selfemp + single + hischl
### Issue the subpop command
set_b <- subpop(fm, data = mortgage, method = "logit", var = "black",
u = 0.1, alpha = 0.1, b = 50)
### Produce summary of two variables
groups <- summary(set_b, vars = c("p_irat", "hse_inc"))
}
