% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPE.R
\name{SPE}
\alias{SPE}
\title{Empirical sorted partial effects (SPE) and inference}
\usage{
SPE(fm, data, method = "ols", var.type = "binary", var.T, compare,
  subgroup = NULL, samp_weight = NULL, us = c(1:9)/10, alpha = 0.1,
  taus = c(1:9)/10, B = 10, ncores = 1, seed = 1, bc = TRUE,
  boot.type = "nonpar")
}
\arguments{
\item{fm}{Regression formula.}

\item{data}{Data in use.}

\item{method}{Models to be used for estimating partial effects. Four options: \code{"logit"} (binary response),
\code{"probit"} (binary response), \code{"ols"} (interactive linear with additive errors), \code{"QR"} (linear model
with non-additive errors). Default is \code{"ols"}.}

\item{var.type}{The type of parameter in interest. Three options: \code{"binary"}, \code{"categorical"}, \code{"continuous"}. Default
is \code{"binary"}.}

\item{var.T}{Variable T in interset. Should be a character type.}

\item{compare}{If parameter in interest is categorical, then user needs to specify which two category to
compare with. Should be a 1 by 2 character vector. For example, if the two levels to compare
with is 1 and 3, then \code{c=("1", "3")}, which will calculate partial effect from 1 to 3. To use
this option, users first need to specify var.T as a factor variable.}

\item{subgroup}{Subgroup in interest. Default is \code{NULL}. Specifcation should be a logical variable. For example, suppose data contains
indicator variable for women (female if 1, male if 0). If users are interested in women SPE, then users
should specify \code{subgroup = data[, "female"] == 1}.}

\item{samp_weight}{Sampling weight of data. If null then function implements empirical bootstrap.
If data specifies sampling weight, the function implements weighted bootstrap. Input
should be a n by 1 vector, where n denotes sample size. Default is \code{NULL}.}

\item{us}{Percentile of interest for SPE. Should be a vector of values between 0 and 1. Default
is \code{c(1:9)/10}.}

\item{alpha}{Size for confidence interval. Shoule be between 0 and 1. Default is 0.1}

\item{taus}{Indexes for quantile regression. Default is \code{c(1:9)/10}.}

\item{B}{Number of bootstrap draws. Default is set to be 10. For more accurate results, we recommend 500.}

\item{ncores}{Number of cores for computation. Default is set to be 1. For large dataset, parallel computing
is highly recommended since bootstrap is time-consuming.}

\item{seed}{Pseudo-number generation for reproduction. Default is 1.}

\item{bc}{Whether want the estimate to be bias-corrected. Default is \code{TRUE}. If \code{FALSE} uncorrected
estimate and corresponding confidence bands will be reported.}

\item{boot.type}{Type of bootstrap. Default is \code{boot.type = "nonpar"}, and the package implements nonparametric
bootstrap. An alternative is \code{boot.type = "weighted"}, and the package implements weighted
bootstrap.}
}
\value{
The output is a list with 4 components: (1) \code{spe} stores spe estimates and confidence bounds;
(2) \code{ape} stores ape estimates and confidence bounds; (3) \code{us} stores percentile index as in
\code{SPE} command; (4) \code{alpha} stores significance level as in \code{SPE} command.
}
\description{
\code{SPE} conducts SPE estimation and inference at user-specifed quantile index. The bootstrap procedures
follows algorithm 2.1 as in Chernozhukov, Fernandez-Val and Luo (2018). All estimates are bias-corrected
and all confidence bands are monotonized. For graphical results, please use \code{\link{SPEplot}}.
}
\examples{
data("mortgage")
fm <- deny ~ black + p_irat + hse_inc + ccred + mcred + pubrec + ltv_med +
ltv_high + denpmi + selfemp + single + hischl
test <- SPE(fm = fm, data = mortgage, var.T = "black", method = "logit",
us = c(1:9)/10)

}
