% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soj_3x_original.R
\name{soj_3x_original}
\alias{soj_3x_original}
\title{Invoke the original triaxial Sojourn method}
\usage{
soj_3x_original(counts, counts.2, counts.3, vect.mag, short = 30)
}
\arguments{
\item{counts}{numeric vector of activity counts from the first axis}

\item{counts.2}{numeric vector of activity counts from the second axis}

\item{counts.3}{numeric vector of activity counts from the third axis}

\item{vect.mag}{vector magnitude of the activity counts}

\item{short}{minimum length of one Sojourn}
}
\value{
a data frame of processed data
}
\description{
Calls the triaxial Sojourn method from \href{https://pubmed.ncbi.nlm.nih.gov/23860415/}{Lyden et al. (2014)}.
}
\examples{
data(example_data, package = "Sojourn")
if (isTRUE(requireNamespace("Sojourn.Data"))) {
results_3x <- soj_3x_original(
  example_data$axis1,
  example_data$axis2,
  example_data$axis3,
  example_data$Vector.Magnitude
)

utils::head(results_3x)
}

}
