% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dist.R
\name{sim_ays_covar}
\alias{sim_ays_covar}
\title{Simulate age-year-space covariance}
\usage{
sim_ays_covar(
  sd = 2.8,
  range = 300,
  lambda = 1,
  model = "matern",
  phi_age = 0.5,
  phi_year = 0.9,
  group_ages = 5:20,
  group_years = NULL
)
}
\arguments{
\item{sd}{Variance (can be age-specific).}

\item{range}{Decorrelation range.}

\item{lambda}{Controls the degree of smoothness in the Matérn covariance process.}

\item{model}{String indicating the correlation function to use: either \code{"exponential"} or \code{"matern"}.}

\item{phi_age}{Autocorrelation through ages. Can be a single value or a vector the same length as \code{ages}.}

\item{phi_year}{Autocorrelation through years. Can be a single value or a vector the same length as \code{years}.}

\item{group_ages}{A vector of ages to group together with shared space-age-year noise.}

\item{group_years}{A vector of years to group together with shared space-age-year noise.}
}
\value{
A function to be passed to \code{\link[=sim_distribution]{sim_distribution()}} as the \code{ays_covar} argument.
}
\description{
These functions return a function to be used inside \code{\link[=sim_distribution]{sim_distribution()}} to simulate
spatially and temporally autocorrelated error.
}
