% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_pop.R
\name{sim_vonB}
\alias{sim_vonB}
\title{Closure for simulating length given age using von Bertalanffy notation}
\usage{
sim_vonB(
  Linf = 120,
  L0 = 5,
  K = 0.1,
  log_sd = 0.1,
  length_group = 3,
  digits = 0,
  plot = FALSE
)
}
\arguments{
\item{Linf}{Mean asymptotic length}

\item{L0}{Length at birth}

\item{K}{Growth rate parameter}

\item{log_sd}{Standard deviation of the relationship in log scale}

\item{length_group}{Length group for length age key. Note that labels on the matrix produced are
midpoints using the DFO conventions; see \code{\link{group_lengths}}. Also
note that this length group will dictate the length group used in the
stratified analysis run by \code{\link{run_strat}}.}

\item{digits}{Integer indicating the number of decimal places to round the values to}

\item{plot}{Produce a simple plot of the simulated values?}
}
\description{
This function outputs a function which holds the parameter values supplied and
the function either simulates lengths given ages or generates a length age key
give a sequence of ages.
}
\examples{
growth_fun <- sim_vonB(Linf = 100, L0 = 5, K = 0.2, log_sd = 0.05, length_group = 1, plot = TRUE)
growth_fun(age = rep(1:15, each = 100))
growth_fun(age = 1:15, length_age_key = TRUE)
sim_abundance(growth = sim_vonB(plot = TRUE))

}
