% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sim_pdf_theory.R
\name{plot_sim_pdf_theory}
\alias{plot_sim_pdf_theory}
\title{Plot Simulated Probability Density Function and Target PDF by Distribution Name or Function for Continuous or Count Variables}
\usage{
plot_sim_pdf_theory(sim_y, title = "Simulated Probability Density Function",
  ylower = NULL, yupper = NULL, power_color = "dark blue",
  overlay = TRUE, cont_var = TRUE, target_color = "dark green",
  target_lty = 2, Dist = c("Benini", "Beta", "Beta-Normal",
  "Birnbaum-Saunders", "Chisq", "Dagum", "Exponential", "Exp-Geometric",
  "Exp-Logarithmic", "Exp-Poisson", "F", "Fisk", "Frechet", "Gamma", "Gaussian",
  "Gompertz", "Gumbel", "Kumaraswamy", "Laplace", "Lindley", "Logistic",
  "Loggamma", "Lognormal", "Lomax", "Makeham", "Maxwell", "Nakagami",
  "Paralogistic", "Pareto", "Perks", "Rayleigh", "Rice", "Singh-Maddala",
  "Skewnormal", "t", "Topp-Leone", "Triangular", "Uniform", "Weibull",
  "Poisson", "Negative_Binomial"), params = NULL, fx = NULL, lower = NULL,
  upper = NULL, legend.position = c(0.975, 0.9),
  legend.justification = c(1, 1), legend.text.size = 10,
  title.text.size = 15, axis.text.size = 10, axis.title.size = 13)
}
\arguments{
\item{sim_y}{a vector of simulated data}

\item{title}{the title for the graph (default = "Simulated Probability Density Function")}

\item{ylower}{the lower y value to use in the plot (default = NULL, uses minimum simulated y value)}

\item{yupper}{the upper y value (default = NULL, uses maximum simulated y value)}

\item{power_color}{the histogram color for the simulated variable}

\item{overlay}{if TRUE (default), the target distribution is also plotted given either a distribution name (and parameters)
or pdf function fx (with bounds = ylower, yupper)}

\item{cont_var}{TRUE (default) for continuous variables, FALSE for count variables}

\item{target_color}{the line color for the target pdf}

\item{target_lty}{the line type for the target pdf (default = 2, dashed line)}

\item{Dist}{name of the distribution. The possible values are: "Benini", "Beta", "Beta-Normal", "Birnbaum-Saunders", "Chisq",
"Exponential", "Exp-Geometric", "Exp-Logarithmic", "Exp-Poisson", "F", "Fisk", "Frechet", "Gamma", "Gaussian", "Gompertz",
"Gumbel", "Kumaraswamy", "Laplace", "Lindley", "Logistic", "Loggamma", "Lognormal", "Lomax", "Makeham", "Maxwell",
"Nakagami", "Paralogistic", "Pareto", "Perks", "Rayleigh", "Rice", "Singh-Maddala", "Skewnormal", "t", "Topp-Leone", "Triangular",
"Uniform", "Weibull", "Poisson", and "Negative_Binomial".
Please refer to the documentation for each package (either \code{\link[stats]{stats}}, \code{\link[VGAM]{VGAM}}, or
\code{\link[triangle]{triangle}}) for information on appropriate parameter inputs.}

\item{params}{a vector of parameters (up to 4) for the desired distribution (keep NULL if \code{fx} supplied instead)}

\item{fx}{a pdf input as a function of x only, i.e. fx <- function(x) 0.5*(x-1)^2; must return a scalar
(keep NULL if \code{Dist} supplied instead)}

\item{lower}{the lower support bound for \code{fx}}

\item{upper}{the upper support bound for \code{fx}}

\item{legend.position}{the position of the legend}

\item{legend.justification}{the justification of the legend}

\item{legend.text.size}{the size of the legend labels}

\item{title.text.size}{the size of the plot title}

\item{axis.text.size}{the size of the axes text (tick labels)}

\item{axis.title.size}{the size of the axes titles}
}
\value{
A \code{\link[ggplot2]{ggplot2}} object.
}
\description{
This plots the pdf of simulated continuous or count data and overlays the target pdf (if \code{overlay} = TRUE),
    which is specified by distribution name (plus up to 4 parameters) or pdf function \code{fx} (plus support bounds).
    If a continuous target distribution is provided (\code{cont_var = TRUE}), the simulated data \eqn{y} is
    scaled and then transformed (i.e. \eqn{y = sigma * scale(y) + mu}) so that it has the same mean (\eqn{mu}) and variance (\eqn{sigma^2}) as the
    target distribution.  If the variable is Negative Binomial, the parameters must be size and success probability (not mu).
    The function returns a \code{\link[ggplot2]{ggplot2}} object so the user can modify as necessary.  The graph parameters (i.e. \code{title},
    \code{power_color}, \code{target_color}, \code{target_lty}) are \code{\link[ggplot2]{ggplot2}} parameters.  It works for valid or invalid power method pdfs.
}
\examples{
\dontrun{
# Logistic Distribution: mean = 0, variance = 1
seed = 1234

# Find standardized cumulants
stcum <- calc_theory(Dist = "Logistic", params = c(0, 1))

# Simulate without the sixth cumulant correction
# (invalid power method pdf)
Logvar1 <- nonnormvar1(method = "Polynomial", means = 0, vars = 1,
                       skews = stcum[3], skurts = stcum[4],
                       fifths = stcum[5], sixths = stcum[6],
                       n = 10000, seed = seed)

# Plot pdfs of simulated variable (invalid) and theoretical distribution
plot_sim_pdf_theory(sim_y = Logvar1$continuous_variable,
                    title = "Invalid Logistic Simulated PDF",
                    overlay = TRUE, Dist = "Logistic", params = c(0, 1))

# Simulate with the sixth cumulant correction
# (valid power method pdf)
Logvar2 <- nonnormvar1(method = "Polynomial", means = 0, vars = 1,
                       skews = stcum[3], skurts = stcum[4],
                       fifths = stcum[5], sixths = stcum[6],
                       Six = seq(1.5, 2, 0.05), n = 10000, seed = seed)

# Plot pdfs of simulated variable (invalid) and theoretical distribution
plot_sim_pdf_theory(sim_y = Logvar2$continuous_variable,
                    title = "Valid Logistic Simulated PDF",
                    overlay = TRUE, Dist = "Logistic", params = c(0, 1))

# Simulate 2 Negative Binomial distributions and correlation 0.3
# using Method 1
NBvars <- rcorrvar(k_nb = 2, size = c(10, 15), prob = c(0.4, 0.3),
                  rho = matrix(c(1, 0.3, 0.3, 1), 2, 2), seed = seed)

# Plot pdfs of 1st simulated variable and theoretical distribution
plot_sim_pdf_theory(sim_y = NBvars$Neg_Bin_variable[, 1], overlay = TRUE,
                    cont_var = FALSE, Dist = "Negative_Binomial",
                    params = c(10, 0.4))

}

}
\references{
Please see the references for \code{\link[SimMultiCorrData]{plot_cdf}}.

Wickham H. ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York, 2009.
}
\seealso{
\code{\link[SimMultiCorrData]{calc_theory}},
    \code{\link[ggplot2]{ggplot}}, \code{\link[ggplot2]{geom_line}}, \code{\link[ggplot2]{geom_density}}
}
\keyword{Fleishman,}
\keyword{Headrick}
\keyword{pdf,}
\keyword{plot,}
\keyword{simulated,}
\keyword{theoretical,}
