% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C-generator.R
\name{C_code}
\alias{C_code}
\title{Extract the C code from a \code{SimInf_model} object}
\usage{
C_code(model)
}
\arguments{
\item{model}{The \code{SimInf_model} object to extract the C code
from.}
}
\value{
Character vector with C code for the model.
}
\description{
Extract the C code from a \code{SimInf_model} object
}
\examples{
## Use the model parser to create a 'SimInf_model' object that
## expresses an SIR model, where 'b' is the transmission rate and
## 'g' is the recovery rate.
model <- mparse(transitions = c("S -> b*S*I/(S+I+R) -> I", "I -> g*I -> R"),
                compartments = c("S", "I", "R"),
                gdata = c(b = 0.16, g = 0.077),
                u0 = data.frame(S = 99, I = 1, R = 0),
                tspan = 1:10)

## View the C code.
C_code(model)
}
