% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_events.R
\name{shift_matrix}
\alias{shift_matrix}
\title{Extract the shift matrix from a \code{SimInf_model} object}
\usage{
shift_matrix(model)
}
\arguments{
\item{model}{The \code{model} to extract the shift matrix
\code{events@N} from.}
}
\value{
A mtrix.
}
\description{
Utility function to extract the shift matrix \code{events@N} from
a \code{SimInf_model} object, see
\code{\linkS4class{SimInf_events}}
}
\examples{
## Create an SIR model
model <- SIR(u0 = data.frame(S = 99, I = 1, R = 0),
             tspan = 1:5, beta = 0.16, gamma = 0.077)

## Extract the shift matrix from the model
shift_matrix(model)
}
