% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_types.R
\name{group_types}
\alias{group_types}
\title{Which types are the different regulation groups?}
\usage{
group_types(beta_fun)
}
\arguments{
\item{beta_fun}{Matrix of co-regulation coefficients}
}
\value{
Return a list of three elements that contains the numbers of the regulation groups:
\itemize{
 \item \code{$grp_pos}: numeric vector containing the position of positive groups
 \item \code{$grp_single}: numeric vector containing the position of singletons
 \item \code{$grp_neg}: numeric vector containing the position of negative groups
}
If there is no group of a type, the corresponding element returns \code{NULL} instead of a numeric vector.
}
\description{
Determines the type of all regulation groups from the matrix of co-regulation coefficients
}
\details{
Regulation groups exist in three types :
\itemize{
 \item positive group, when all regulation coefficients are positive
 \item negative group, when it exists at least one negative regulation coefficients in the group
 \item singletons, when enzyme is lone in the group, and is therefore independent from all others enzymes
}

The position of the groups is determined from the list of regulation, computed with function \code{\link{class_group}}.
}
\examples{

#Only one group
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
L_Phi <- class_group(beta)
group_types(beta) #gives c(1), NULL and NULL


#Two groups
n <- 3
beta <- diag(1,n) 
beta[1,2] <- -0.32 
beta[2,1] <- 1/beta[1,2]

L_Phi <- class_group(beta)
group_types(beta) #gives NULL, c(2) and c(1)

#with data
data(data_sim_RegNeg_1grpNeg1grpPos)
group_types(data_sim_RegNeg_1grpNeg1grpPos$param$beta)


}
\seealso{
Function \code{\link{class_group}} to compute the list of regulation groups
}
