% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_levels.R
\name{set_levels}
\alias{set_levels}
\title{Set simulation levels}
\usage{
set_levels(sim, ..., .keep = NA)
}
\arguments{
\item{sim}{A simulation object of class \code{sim_obj}, usually created by
\code{\link{new_sim}}}

\item{...}{One or more key-value pairs representing simulation levels. Each
value can either be a vector (for simple levels) or a list of lists (for
more complex levels). See examples.}

\item{.keep}{An integer vector specifying which level combinations to keep;
see examples.}
}
\value{
The original simulation object with the old set of levels replaced
    with the new set
}
\description{
Set one or more simulation levels, which are things that vary
    between simulation replicates.
}
\examples{
# Basic usage is as follows:
sim <- new_sim()
sim \%<>\% set_levels(
  "n" = c(10, 100, 1000),
  "theta" = c(2, 3)
)
sim$levels

# More complex levels can be set using lists:
sim <- new_sim()
sim \%<>\% set_levels(
  "n" = c(10, 100, 1000),
  "theta" = c(2, 3),
  "method" = list(
    "spline1" = list(knots=c(2,4), slopes=c(0.1,0.4)),
    "spline2" = list(knots=c(1,5), slopes=c(0.2,0.3))
  )
)
sim$levels

# If you don't want to run simulations for all level combinations, use the
# .keep option. First, set the levels normally. Second, view the
# sim$levels_grid dataframe to examine the level combinations and the
# associated level_id values. Third, call set_levels again with the .keep
# option to specify which levels to keep (via a vector of level_id values).
sim <- new_sim()
sim \%<>\% set_levels(alpha=c(1,2,3), beta=c(5,6))
sim$levels_grid
sim \%<>\% set_levels(.keep=c(1,2,6))
sim$levels_grid
}
