% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{rHeadrick}
\alias{rHeadrick}
\title{Generate non-normal data with Headrick's (2002) method}
\usage{
rHeadrick(n, mean = rep(0, nrow(sigma)), sigma = diag(length(mean)),
  skew = rep(0, nrow(sigma)), kurt = rep(0, nrow(sigma)), gam3 = NaN,
  gam4 = NaN, return_coefs = FALSE, coefs = NULL, control = list(seed =
  NULL, trace = FALSE, max.ntry = 15, obj.tol = 1e-10, n.valid.sol = 1))
}
\arguments{
\item{n}{sample size}

\item{mean}{a vector of k elements for the mean of the variables}

\item{sigma}{desired k x k covariance matrix between bivariate non-normal variables}

\item{skew}{a vector of k elements for the skewness of the variables}

\item{kurt}{a vector of k elements for the kurtosis of the variables}

\item{gam3}{(optional) explicitly supply the gamma 3 value? Default computes this internally}

\item{gam4}{(optional) explicitly supply the gamma 4 value? Default computes this internally}

\item{return_coefs}{logical; return the estimated coefficients only? See below regarding why this is useful.}

\item{coefs}{(optional) supply previously estimated coefficients? This is useful when there must be multiple
data sets drawn and will avoid repetitive computations. Must be the object returned after passing
\code{return_coefs = TRUE}}

\item{control}{a list of control parameters when locating the polynomial coefficients}
}
\description{
Generate multivariate non-normal distributions using the fifth-order polynomial method described by Headrick (2002).
}
\details{
This function is primarily a wrapper for the code written by Oscar L. Olvera Astivia (last edited Feb 26, 2015)
with some modifications (e.g., better starting values for the Newton optimizer, passing previously saved
coefs, etc).
}
\examples{

\dontrun{
set.seed(1)

N <- 200
mean <- c(rep(0,4))
Sigma <- matrix(.49, 4, 4)
diag(Sigma) <- 1
skewness <- c(rep(1,4))
kurtosis <- c(rep(2,4))

nonnormal <- rHeadrick(N, mean, Sigma, skewness, kurtosis)
# cor(nonnormal)
# psych::describe(nonnormal)

#-----------
# compute the coefficients, then supply them back to the function to avoid
# extra computations

cfs <- rHeadrick(N, mean, Sigma, skewness, kurtosis, return_coefs = TRUE)
cfs

# compare
system.time(nonnormal <- rHeadrick(N, mean, Sigma, skewness, kurtosis))
system.time(nonnormal <- rHeadrick(N, mean, Sigma, skewness, kurtosis,
                                   coefs=cfs))
}

}
\references{
Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\url{http://www.tandfonline.com/doi/full/10.1080/10691898.2016.1246953}

Headrick, T. C. (2002). Fast fifth-order polynomial transforms for generating univariate and
multivariate nonnormal distributions. \emph{Computational Statistics & Data Analysis, 40}, 685-711.

Olvera Astivia, O. L., & Zumbo, B. D. (2015). A Cautionary Note on the Use of the Vale and Maurelli
Method to Generate Multivariate, Nonnormal Data for Simulation Purposes.
\emph{Educational and Psychological Measurement, 75}, 541-567.
}
\author{
Oscar L. Olvera Astivia and Phil Chalmers
}
