% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_error.R
\name{corr_error}
\alias{corr_error}
\title{Error Loop to Correct Final Correlation of Simulated Variables}
\usage{
corr_error(n = 10000, k_cat = 0, k_cont = 0, k_pois = 0, k_nb = 0,
  method = c("Fleishman", "Polynomial"), means = NULL, vars = NULL,
  constants = NULL, marginal = list(), support = list(), lam = NULL,
  p_zip = 0, size = NULL, mu = NULL, p_zinb = 0, seed = 1234,
  epsilon = 0.001, maxit = 1000, rho0 = NULL, Sigma = NULL,
  rho_calc = NULL)
}
\arguments{
\item{n}{the sample size}

\item{k_cat}{the number of ordinal (r >= 2 categories) variables}

\item{k_cont}{the number of continuous variables (these may be regular continuous variables or components of continuous mixture variables)}

\item{k_pois}{the number of Poisson (regular or zero-inflated) variables}

\item{k_nb}{the number of Negative Binomial (regular or zero-inflated) variables}

\item{method}{the method used to generate the continuous variables.  "Fleishman" uses a third-order polynomial transformation
and "Polynomial" uses Headrick's fifth-order transformation.}

\item{means}{a vector of means for the continuous variables}

\item{vars}{a vector of variances for the continuous variables}

\item{constants}{a matrix with \code{k_cont} rows, each a vector of constants c0, c1, c2, c3 (if \code{method} = "Fleishman") or
c0, c1, c2, c3, c4, c5 (if \code{method} = "Polynomial"), like that returned by \code{\link[SimMultiCorrData]{find_constants}}}

\item{marginal}{a list of length equal \code{k_cat}; the i-th element is a vector of the cumulative
probabilities defining the marginal distribution of the i-th variable;
if the variable can take r values, the vector will contain r - 1 probabilities (the r-th is assumed to be 1)}

\item{support}{a list of length equal \code{k_cat}; the i-th element is a vector of containing the r
ordered support values; if not provided, the default is for the i-th element to be the vector 1, ..., r}

\item{lam}{a vector of lambda (mean > 0) constants for the Poisson variables (see \code{stats::dpois}); the order should be
1st regular Poisson variables, 2nd zero-inflated Poisson variables}

\item{p_zip}{a vector of probabilities of structural zeros (not including zeros from the Poisson distribution) for the zero-inflated
Poisson variables (see \code{VGAM::dzipois})}

\item{size}{a vector of size parameters for the Negative Binomial variables (see \code{stats::dnbinom}); the order should be
1st regular NB variables, 2nd zero-inflated NB variables}

\item{mu}{a vector of mean parameters for the NB variables; order the same as in \code{size}; for zero-inflated NB this refers to
the mean of the NB distribution (see \code{VGAM::dzinegbin})}

\item{p_zinb}{a vector of probabilities of structural zeros (not including zeros from the NB distribution) for the zero-inflated NB variables
(see \code{VGAM::dzinegbin})}

\item{seed}{the seed value for random number generation}

\item{epsilon}{the maximum acceptable error between the final and target pairwise correlation; smaller epsilons take more time}

\item{maxit}{the maximum number of iterations to use to find the intermediate correlation; the
correction loop stops when either the iteration number passes \code{maxit} or \code{epsilon} is reached}

\item{rho0}{the target correlation matrix}

\item{Sigma}{the intermediate correlation matrix previously used in \code{\link[SimCorrMix]{corrvar}}
or \code{\link[SimCorrMix]{corrvar2}}}

\item{rho_calc}{the final correlation matrix calculated in \code{\link[SimCorrMix]{corrvar}}
or \code{\link[SimCorrMix]{corrvar2}} before execution of \code{\link[SimCorrMix]{corr_error}}}
}
\value{
A list with the following components:

\code{Sigma} the intermediate MVN correlation matrix resulting from the error loop

\code{rho_calc} the calculated final correlation matrix generated from Sigma

\code{Y_cat} the ordinal variables

\code{Y} the continuous (mean 0, variance 1) variables

\code{Y_cont} the continuous variables with desired mean and variance

\code{Y_pois} the Poisson variables

\code{Y_nb} the Negative Binomial variables

\code{niter} a matrix containing the number of iterations required for each variable pair
}
\description{
This function attempts to correct the final pairwise correlations of simulated variables to be within \code{epsilon}
    of the target correlations.  It updates the intermediate normal correlation iteratively in a loop until either the maximum error
    is less than epsilon or the number of iterations exceeds \code{maxit}.  This function would not ordinarily be called directly by
    the user.  The function is a modification of  Barbiero & Ferrari's \code{\link[GenOrd]{ordcont}} function in
    \code{\link[GenOrd]{GenOrd-package}}.  The \code{\link[GenOrd]{ordcont}} function has been modified in the following ways:

    1) It works for continuous, ordinal (r >= 2 categories), and count (regular or zero-inflated, Poisson or Negative Binomial) variables.

    2) The initial correlation check has been removed because the intermediate correlation matrix
    \code{Sigma} from \code{\link[SimCorrMix]{corrvar}} or \code{\link[SimCorrMix]{corrvar2}} has already been
    checked for positive-definiteness and used to generate variables.

    3) Eigenvalue decomposition is done on \code{Sigma} to impose the correct intermediate correlations on the normal variables.
    If \code{Sigma} is not positive-definite, the negative eigenvalues are replaced with 0.

    4) The final positive-definite check has been removed.

    5) The intermediate correlation update function was changed to accommodate more situations.

    6) Allowing specifications for the sample size and the seed for reproducibility.

    The vignette \bold{Variable Types} describes the algorithm used in the error loop.
}
\references{
Please see references for \code{\link[SimCorrMix]{SimCorrMix}}.
}
\seealso{
\code{\link[SimCorrMix]{corrvar}}, \code{\link[SimCorrMix]{corrvar2}}
}
\keyword{correlation}
\keyword{error}
