% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{GetIntersectingFeatures}
\alias{GetIntersectingFeatures}
\title{Find interesecting regions between two objects}
\usage{
GetIntersectingFeatures(
  object.1,
  object.2,
  assay.1 = NULL,
  assay.2 = NULL,
  distance = 0,
  verbose = TRUE
)
}
\arguments{
\item{object.1}{The first Seurat object}

\item{object.2}{The second Seurat object}

\item{assay.1}{Name of the assay to use in the first object. If NULL, use
the default assay}

\item{assay.2}{Name of the assay to use in the second object. If NULL, use
the default assay}

\item{distance}{Maximum distance between regions allowed for an intersection
to be recorded. Default is 0.}

\item{verbose}{Display messages}
}
\value{
Returns a list of two character vectors containing the row names
in each object that overlap each other.
}
\description{
Intersects the regions stored in the rownames of two objects and
returns a vector containing the names of rows that interesect
for each object. The order of the row names return corresponds
to the intersecting regions, ie the nth feature of the first vector
will intersect the nth feature in the second vector. A distance
parameter can be given, in which case features within the given
distance will be called as intersecting.
}
\examples{
GetIntersectingFeatures(
  object.1 = atac_small,
  object.2 = atac_small,
  assay.1 = 'peaks',
  assay.2 = 'bins'
)
}
\concept{utilities}
