% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDIFirt.R
\name{plotDIFirt}
\alias{plotDIFirt}
\title{Function for characteristic curve of DIF IRT model}
\usage{
plotDIFirt(parameters, test = "Lord", item = 1)
}
\arguments{
\item{parameters}{numeric: data matrix or data frame. See \strong{Details}.}

\item{test}{character: type of statistic to be shown.}

\item{item}{numeric: number of item to be plotted.}
}
\description{
Plots characteristic curve of IRT model.
}
\details{
This function plots characteristic curve of DIF IRT model.
}
\examples{
\dontrun{
# loading libraries
library(difNLR, difR)

 # loading data based on GMAT
data(GMAT, package = "difNLR")
data  <- GMAT[, colnames(GMAT) != "group"]
group <- GMAT[, "group"]

# Estimation of 2PL IRT model
fitR <- itemParEst(data[group == 0, ], model = "2PL")
fitF <- itemParEst(data[group == 1, ], model = "2PL")

# Estimated parameters with sd for item 1
est <- c(fitR[1, 1:2], fitF[1, 1:2])[c(1, 3, 2, 4)]
sd <- c(fitR[1, 3:4], fitF[1, 3:4])[c(1, 3, 2, 4)]
parameters <- data.frame(est, sd)

# Characteristic curve for item 1
plotDIFirt(parameters, item = 1)

# Characteristic curve for item 1 with highlighted area between curves
plotDIFirt(parameters, item = 1, test = "Raju")
}


}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
adela.drabinova@gmail.com \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}

