% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimreduc.R
\name{DimReduc-methods}
\alias{DimReduc-methods}
\alias{[.DimReduc}
\alias{[[.DimReduc}
\alias{dim.DimReduc}
\alias{dimnames.DimReduc}
\alias{length.DimReduc}
\alias{merge.DimReduc}
\alias{names.DimReduc}
\alias{print.DimReduc}
\alias{print}
\alias{subset.DimReduc}
\alias{show,DimReduc-method}
\title{\code{DimReduc} Methods}
\usage{
\method{[}{DimReduc}(x, i, j, drop = FALSE, ...)

\method{[[}{DimReduc}(x, i, j, drop = FALSE, ...)

\method{dim}{DimReduc}(x)

\method{dimnames}{DimReduc}(x)

\method{length}{DimReduc}(x)

\method{merge}{DimReduc}(x = NULL, y = NULL, add.cell.ids = NULL, ...)

\method{names}{DimReduc}(x)

\method{print}{DimReduc}(x, dims = 1:5, nfeatures = 20, projected = FALSE, ...)

\method{subset}{DimReduc}(x, cells = NULL, features = NULL, ...)

\S4method{show}{DimReduc}(object)
}
\arguments{
\item{x, object}{A \code{\link{DimReduc}} object}

\item{i}{For \code{[}: feature names or indices; for \code{[[}: cell names
or indices}

\item{j}{Dimensions to pull for}

\item{drop}{See \code{\link[base]{drop}}}

\item{...}{Arguments passed to other methods}

\item{y}{A vector or list of one or more objects to merge}

\item{add.cell.ids}{A character vector of \code{length(x = c(x, y))};
appends the corresponding values to the start of each objects' cell names}

\item{dims}{Number of dimensions to display}

\item{nfeatures}{Number of genes to display}

\item{projected}{Use projected slot}

\item{cells, features}{Cells and features to keep during the subset}
}
\value{
\code{[}: Feature loadings for features \code{i} and dimensions
\code{j}

\code{[[}: Cell embeddings for cells \code{i} and dimensions \code{j}

\code{dim}: The number of cells (\code{nrow}) and dimensions
(\code{ncol})

\code{dimnames}: The cell (row) and dimension (column) names

\code{length}: The number of dimensions

\code{names}: The names for the dimensions (eg. \dQuote{PC_1})

\code{print}: Displays set of features defining the components and
invisibly returns \code{x}

\code{subset}: \code{x} for cells \code{cells} and features
\code{features}

\code{show}: Prints summary to \code{\link[base]{stdout}} and
invisibly returns \code{NULL}
}
\description{
Methods for \code{\link{DimReduc}} objects for generics defined in
other packages
}
\section{Functions}{
\itemize{
\item \code{[}: Pull feature loadings

\item \code{[[}: Pull cell embeddings

\item \code{dim(DimReduc)}: The number of cells and dimensions for a
\code{DimReduc}

\item \code{dimnames(DimReduc)}: The cell and dimension names for a
\code{DimReduc} object

\item \code{length(DimReduc)}: The number of dimensions for a \code{DimReduc}
object

\item \code{merge(DimReduc)}: Merge two or more \code{DimReduc} objects
together

\item \code{names(DimReduc)}: The dimension names for a \code{DimReduc} object

\item \code{print(DimReduc)}: Prints a set of features that most strongly
define a set of components; \strong{note}: requires feature loadings to be
present in order to work

\item \code{subset(DimReduc)}: Subset a \code{DimReduc} object

\item \code{show(DimReduc)}: Show basic summary of a \code{DimReduc} object

}}
\seealso{
\code{\link[base]{cat}}
}
\concept{dimreduc}
