% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{VizDimLoadings}
\alias{VizDimLoadings}
\title{Visualize Dimensional Reduction genes}
\usage{
VizDimLoadings(
  object,
  dims = 1:5,
  nfeatures = 30,
  col = "blue",
  reduction = "pca",
  projected = FALSE,
  balanced = FALSE,
  ncol = NULL,
  combine = TRUE
)
}
\arguments{
\item{object}{Seurat object}

\item{dims}{Number of dimensions to display}

\item{nfeatures}{Number of genes to display}

\item{col}{Color of points to use}

\item{reduction}{Reduction technique to visualize results for}

\item{projected}{Use reduction values for full dataset (i.e. projected
dimensional reduction values)}

\item{balanced}{Return an equal number of genes with + and - scores. If
FALSE (default), returns the top genes ranked by the scores absolute values}

\item{ncol}{Number of columns to display}

\item{combine}{Combine plots into a single \code{\link[patchwork]{patchwork}ed}
ggplot object. If \code{FALSE}, return a list of ggplot objects}
}
\value{
A \code{\link[patchwork]{patchwork}ed} ggplot object if
\code{combine = TRUE}; otherwise, a list of ggplot objects
}
\description{
Visualize top genes associated with reduction components
}
\examples{
VizDimLoadings(object = pbmc_small)

}
