% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction_utilities.R
\name{ICTopCells}
\alias{ICTopCells}
\title{Find cells with highest ICA scores}
\usage{
ICTopCells(object, ic.use = 1, num.cells = NULL, do.balanced = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{ic.use}{Independent component to use}

\item{num.cells}{Number of cells to return}

\item{do.balanced}{Return an equal number of cells with both + and - PC scores.}
}
\value{
Returns a vector of cells
}
\description{
Return a list of genes with the strongest contribution to a set of principal
components
}
\examples{
pbmc_small
pbmc_small <- RunICA(object = pbmc_small, ics.compute = 10, ics.print = 0)
pbmc_small <- ProjectDim(object = pbmc_small, reduction.type = "ica", do.print = FALSE)
ICTopCells(object = pbmc_small)
# Can specify which dimension and how many cells to return
ICTopCells(object = pbmc_small, ic.use = 2, num.cells = 5)

}
