% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{MarkerTest}
\alias{MarkerTest}
\title{ROC-based marker discovery}
\usage{
MarkerTest(object, cells.1, cells.2, genes.use = NULL, print.bar = TRUE)
}
\arguments{
\item{object}{Seurat object}

\item{cells.1}{Group 1 cells}

\item{cells.2}{Group 2 cells}

\item{genes.use}{Genes to test. Default is to use all genes}

\item{print.bar}{Print a progress bar once expression testing begins (uses pbapply to do this)}
}
\value{
Returns a 'predictive power' (abs(AUC-0.5)) ranked matrix of
putative differentially expressed genes.
}
\description{
Identifies 'markers' of gene expression using ROC analysis. For each gene,
evaluates (using AUC) a classifier built on that gene alone, to classify
between two groups of cells.
}
\details{
An AUC value of 1 means that expression values for this gene alone can
perfectly classify the two groupings (i.e. Each of the cells in cells.1
exhibit a higher level than each of the cells in cells.2). An AUC value of 0
also means there is perfect classification, but in the other direction. A
value of 0.5 implies that the gene has no predictive power to classify the
two groups.
}
\examples{
pbmc_small
MarkerTest(pbmc_small, cells.1 = WhichCells(object = pbmc_small, ident = 1),
            cells.2 = WhichCells(object = pbmc_small, ident = 2))

}
