% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{create_module_from_adjacency_matrix}
\alias{create_module_from_adjacency_matrix}
\title{Create a module from an adjacency matrix}
\usage{
create_module_from_adjacency_matrix(adjacency_matrix, nodes = NULL,
  module_name = NULL, run_checks = TRUE)
}
\arguments{
\item{adjacency_matrix}{The adjacency matrix used to create the module.}

\item{nodes}{A numeric vector indicating which nodes in the network are
contained in this module.}

\item{module_name}{(optional) Character string specifying the name of the 
module. If NULL, the module will be unnamed.}

\item{run_checks}{If TRUE, then the 'adjacency_matrix' argument is checked.}
}
\value{
A 'network_module' object.
}
\description{
The edges in the module will be set to the edges in the adjacency matrix. 
The edges are undirected, and only the lower triangle of the
matrix is considered. See ?set_module_edges for more details.
}
\examples{
nw <- random_network(10)
nw <- gen_partial_correlations(nw)
adj_mat <- get_adjacency_matrix(nw)
create_module_from_adjacency_matrix(adj_mat)
}
