% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SentimentDictionary.R
\name{write}
\alias{write}
\alias{write.SentimentDictionaryWordlist}
\alias{write.SentimentDictionaryBinary}
\alias{write.SentimentDictionaryWeighted}
\title{Write dictionary to text file}
\usage{
write(d, file)

\method{write}{SentimentDictionaryWordlist}(d, file)

\method{write}{SentimentDictionaryBinary}(d, file)

\method{write}{SentimentDictionaryWeighted}(d, file)
}
\arguments{
\item{d}{Dictionary of type \code{\link{SentimentDictionaryWordlist}},
\code{\link{SentimentDictionaryBinary}} or
\code{\link{SentimentDictionaryWeighted}}}

\item{file}{File to which the dictionary should be exported}
}
\description{
This routine exports a sentiment dictionary to a text file which can be the source
for additional problems or controlling the output.
}
\examples{
d.out <- SentimentDictionary(c("uncertain", "possible", "likely"))
write(d.out, "example.dict")
d.in <- read("example.dict")
print(d.in)

d.out <- SentimentDictionary(c("increase", "rise", "more"),
                             c("fall", "drop"))
write(d.out, "example.dict")
d.in <- read("example.dict")
print(d.in)

d.out <- SentimentDictionary(c("increase", "decrease", "exit"),
                             c(+1, -1, -10),
                             rep(NA, 3),
                             intercept=5)
write(d.out, "example.dict")
d.in <- read("example.dict")
print(d.in)

unlink("example.dict")
}
\seealso{
\code{\link{read}} for later access
}
\keyword{dictionary}
