% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformIntoCorpus.R
\name{transformIntoCorpus}
\alias{transformIntoCorpus}
\title{Transforms the input into a Corpus object}
\usage{
transformIntoCorpus(x)
}
\arguments{
\item{x}{A list, data.frame or vector consisting of characters}
}
\value{
The generated \code{Corpus}
}
\description{
Takes the given input of characters and transforms it into a \code{\link[tm]{Corpus}}. The input is checked to match the expected class and format.
}
\note{
Factors are automatically casted into characters but with printing a warning
}
\examples{
transformIntoCorpus(c("Document 1", "Document 2", "Document 3"))
transformIntoCorpus(list("Document 1", "Document 2", "Document 3"))
transformIntoCorpus(data.frame("Document 1", "Document 2", "Document 3"))
}
\seealso{
\code{\link{preprocessCorpus}} for further preprocessing, \code{\link{analyzeSentiment}} for subsequent sentiment analysis
}
\keyword{corpus}
\keyword{preprocessing}
