% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chirps.R
\name{load_chirps}
\alias{load_chirps}
\title{Function for loading CHIRPS (monthly) data.}
\usage{
load_chirps(
  years = NULL,
  months = NULL,
  version = "UCSB",
  resolution = "low",
  us = (resolution == "low"),
  load_prelim = TRUE
)
}
\arguments{
\item{years, months}{Optional subset of years and months you want to load. The default is to load everything that has been downloaded locally.
You can update your local CHIRPS download by calling download_chirps_monthly}

\item{version}{Either 'UCSB' to load the original version from UCSB or 'ICPAC' to load CHIRPS blended (both need to be downloaded first).}

\item{resolution}{Either 'low' for loading the coarser upscaled version, or 'high' for loading the data on full resolution}

\item{us}{logical. If TRUE, the upscaled version is loaded. Takes precedence over resolution.}

\item{load_prelim}{logical. Should preliminary data be loaded? Note that the preliminary data is always from UCSB, not from ICPAC.}
}
\value{
the derived data table
}
\description{
The data has to be previously downloaded, see \code{download_chirps_monthly}. The resulting data table contains precip in unit mm/day.
}
\examples{
if(interactive()){
load_chirps()
}
}
