% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/y_count_labeler.R
\name{y_count_labeler}
\alias{y_count_labeler}
\title{Generate y-axis Label Based on SWMP Parameter Abbreviation}
\usage{
y_count_labeler(param, parameter_threshold, threshold_type,
  time_threshold = NULL, converted = FALSE)
}
\arguments{
\item{param}{chr string of variable abbreviation}

\item{parameter_threshold}{vector of numerical thresholds to evaluate parameters against}

\item{threshold_type}{vector of logical operators ('<', '>', '<=', '>=', '==', '!=')}

\item{time_threshold}{The amount of time an event must last to be counted (in hours)}

\item{converted}{logical, should the parameter label units be converted from metric to english? Defaults to \code{FALSE}. Currently available for \code{temp}, \code{depth}, \code{cdepth}, \code{level}, \code{clevel}, \code{atemp}, \code{wspd}, \code{maxwspd}, and \code{totprcp}}
}
\value{
Returns character vector or an unevaluated expression
}
\description{
Generate a y-axis label based on SWMP parameter abbreviation and threshold criteria
}
\details{
A helper function used internally by several plotting functions to generate y-axis labels. This function does not convert sample results from metric to english. It only adjusts the units in the y-axis label.
}
\examples{
y_lab <- y_count_labeler(param = 'do_mgl', parameter_threshold = 2
, threshold_type = '<', time_threshold = 2, converted = FALSE)

}
\author{
Julie Padilla
}
\concept{miscellaneous}
