% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/swmpr_retrieval.R
\name{import_remote}
\alias{import_remote}
\title{Import SWMP data from Amazon web services}
\usage{
import_remote(station_code)
}
\arguments{
\item{station_code}{chr string of station to import, i.e., 7 or 8 characters indicating the reserve, site, and data type.  Do not include years.}
}
\value{
Returns a swmpr object.
}
\description{
Import SWMP data that are stored on Amazon web services as .RData files.  Data include almost all available data from 1994 to 2014 for every SWMP station.
}
\details{
This function allows quick retrieval of .RData files for all data at a single SwMP site.  It differs from the other data retrieval functions in that the raw data are downloaded from an independent remote server.  Retrieval time is much faster because the files are in binary format for quick import.  However, the data are only available up to December 2014 and may not be regularly updated.  Always use the CDMO for current data.  The data have also been pre-processed using the \code{\link{qaqc}} and \code{\link{setstep}} functions.

The files are available here: \url{https://s3.amazonaws.com/swmpalldata/}.  Files can be obtained using the function or by copying the URL to a web browser with the station name appended to the address, including the .RData file extension.  For example, \url{https://s3.amazonaws.com/swmpalldata/acebbnut.RData}.
}
\examples{
## import a file
dat <- import_remote('rkbmbwq')

head(dat)

attributes(dat)
}
\seealso{
\code{\link{import_local}}
}

