% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mpplot.R
\name{Mpplot}
\alias{Mpplot}
\title{Traces of the space.}
\usage{
Mpplot(MpData)
}
\arguments{
\item{MpData}{object of class ConstructMPst.}
}
\value{
Graphic of the three perspectives for space data "x", "y", "z", with divisions that contain the number of points in each quadrat.
}
\description{
Visualization of the spatial distribution according with three perspectives. Each face has the distribution for trace x, y and z (see \code{\link{ConstructMPst}}).
}
\examples{
library(zoo)
data(Metadb)
#records of monthly precipitation from january 2007 to january 2010
Metadb<-Metadb[,c(1:4,89:125)]
x<-matrix(0,1,37)
for(i in 1:37){
 x[,i] <- 2007 + (seq(0, 36)/12)[i]
}
x<-as.Date (as.yearmon(x), frac = 1)
time = as.POSIXct(x, tz = "GMT")

MPST<-ConstructMPst(Metadb[,-c(1:4)],time,pts=Metadb[,2:4],Delta=c(7,6,5))
Mpplot(MPST)

}
