\docType{data}
    \name{wheat_data}
    \alias{wheat_data}
    \title{Genotyping and phenotypic dataset for wheat}
    \format{A data frame with 50 rows as genotypes with 101 columns (i.e. First 100 columns contains information of genotyped markers and last column represent data of phenotypic trait under study).}
    \details{
    This dataset is created by taking 50 wheat lines genotyped for 100 Markers as a subset from CIMMYT 599 wheat lines. Wheat lines were genotyped using 1447 Diversity Array Technology markers generated by Triticarte Pty. Ltd. (Canberra, Australia; http://www.triticarte.com.au). These markers may take two different values i.e. their presence (1) or absence (0). Phenotypic trait used under this study is grain yield.

    }
    \source{
      International Maize and Wheat Improvement Center (CIMMYT), Mexico.
    }
    \description{
     Dataset used in this study is subset from CIMMYT 599 wheat lines. In our sample dataset it has one response for 50 lines genotyped for 100 markers.
    }

    \usage{data("wheat_data")}

\examples{

library(STGS)

data(wheat_data)

X<-wheat_data[,1:100] #### Extracting Genotype

Y<-as.data.frame(wheat_data[,101]) #### Extracting Phenotype

}
